"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "wrench",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.empty.title', {
    defaultMessage: 'Add documents to tune relevance'
  })),
  body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.empty.description', {
    defaultMessage: 'A schema will be automatically created for you after you index some documents.'
  }),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    target: "_blank",
    iconType: "popout",
    href: _doc_links.docLinks.appSearchRelevance
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.empty.buttonLabel', {
    defaultMessage: 'Read the relevance tuning guide'
  }))
});
exports.EmptyState = EmptyState;