"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCreationButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../shared/doc_links");
var _query_params = require("../../../shared/query_params");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _routes = require("../../routes");
var _engine = require("../engine");
var _illustration = _interopRequireDefault(require("./illustration.svg"));
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCreationButtons = ({
  isFlyout = false,
  disabled = false
}) => {
  const {
    openDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    method
  } = (0, _query_params.parseQueryParams)(search);
  (0, _react.useEffect)(() => {
    switch (method) {
      case 'json':
        openDocumentCreation('json');
        break;
      case 'api':
        openDocumentCreation('api');
        break;
    }
  }, []);
  const crawlerLink = (0, _engine.generateEnginePath)(_routes.ENGINE_CRAWLER_PATH);
  const helperText = /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.helperText', {
    defaultMessage: 'There are three ways to send documents to your engine for indexing. You can paste or upload a JSON file, POST to the documents API endpoint, or use the  Elastic Web Crawler to automatically index documents from a URL.'
  }));
  const emptyState = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _illustration.default,
      alt: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.emptyStateIllustrationAltText', {
        defaultMessage: 'Illustration'
      })
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.emptyStateTitle', {
      defaultMessage: 'Add documents'
    })),
    layout: "horizontal",
    hasBorder: true,
    color: "plain",
    body: helperText,
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.emptyStateFooterText', {
      defaultMessage: 'Want to learn more about indexing documents?'
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.appSearchIndexingDocs,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.emptyStateFooterLink', {
      defaultMessage: 'Read documentation'
    })))
  }));
  const flyoutHeader = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, helperText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFlyout && flyoutHeader, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiCardTo, {
    hasBorder: true,
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.crawlTitle', {
      defaultMessage: 'Use the Crawler'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.crawlDescription', {
      defaultMessage: 'Automatically index documents from a URL'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "globe",
      size: "xl",
      color: "primary"
    }),
    to: crawlerLink,
    isDisabled: disabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.jsonTitle', {
      defaultMessage: 'Paste or upload JSON'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.jsonDescription', {
      defaultMessage: 'Add documents by pasting or uploading raw JSON'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "indexEdit",
      size: "xl",
      color: "primary"
    }),
    "data-test-subj": "IndexingPasteJSONButton",
    onClick: () => openDocumentCreation('json'),
    isDisabled: disabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.apiTitle', {
      defaultMessage: 'Index from API'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.buttons.apiDescription', {
      defaultMessage: 'POST to the documents endpoint'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "exportAction",
      size: "xl",
      color: "primary"
    }),
    onClick: () => openDocumentCreation('api'),
    isDisabled: disabled
  })), !isFlyout && emptyState));
};
exports.DocumentCreationButtons = DocumentCreationButtons;