"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_DOCUMENT_ACTION = exports.RESULT_ACTIONS_DIRECTIONS = exports.RESTORE_CONFIRMATION = exports.QUERY_INPUTS_PLACEHOLDER = exports.QUERY_INPUTS_BUTTON = exports.PROMOTE_DOCUMENT_ACTION = exports.MANAGE_CURATION_TITLE = exports.HIDE_DOCUMENT_ACTION = exports.DEMOTE_DOCUMENT_ACTION = exports.DELETE_SUCCESS_MESSAGE = exports.DELETE_CONFIRMATION_MESSAGE = exports.CURATIONS_TITLE = exports.CURATIONS_OVERVIEW_TITLE = exports.CREATE_NEW_CURATION_TITLE = exports.COVERT_TO_MANUAL_BUTTON_LABEL = exports.CONVERT_TO_MANUAL_CONFIRMATION = exports.AUTOMATED_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CURATIONS_TITLE = exports.CURATIONS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.title', {
  defaultMessage: 'Curations'
});
const CURATIONS_OVERVIEW_TITLE = exports.CURATIONS_OVERVIEW_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.overview.title', {
  defaultMessage: 'Curated results'
});
const CREATE_NEW_CURATION_TITLE = exports.CREATE_NEW_CURATION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.create.title', {
  defaultMessage: 'Create a curation'
});
const MANAGE_CURATION_TITLE = exports.MANAGE_CURATION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.manage.title', {
  defaultMessage: 'Manage curation'
});
const QUERY_INPUTS_BUTTON = exports.QUERY_INPUTS_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.addQueryButtonLabel', {
  defaultMessage: 'Add query'
});
const QUERY_INPUTS_PLACEHOLDER = exports.QUERY_INPUTS_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.queryPlaceholder', {
  defaultMessage: 'Enter a query'
});
const DELETE_CONFIRMATION_MESSAGE = exports.DELETE_CONFIRMATION_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.deleteConfirmation', {
  defaultMessage: 'Are you sure you want to remove this curation?'
});
const DELETE_SUCCESS_MESSAGE = exports.DELETE_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.deleteSuccessMessage', {
  defaultMessage: 'Your curation was deleted'
});
const RESTORE_CONFIRMATION = exports.RESTORE_CONFIRMATION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.restoreConfirmation', {
  defaultMessage: 'Are you sure you want to clear your changes and return to your default results?'
});
const CONVERT_TO_MANUAL_CONFIRMATION = exports.CONVERT_TO_MANUAL_CONFIRMATION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.convertToManualCurationConfirmation', {
  defaultMessage: 'Are you sure you want to convert this to a manual curation?'
});
const RESULT_ACTIONS_DIRECTIONS = exports.RESULT_ACTIONS_DIRECTIONS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.resultActionsDescription', {
  defaultMessage: 'Promote results by clicking the star, hide them by clicking the eye.'
});
const PROMOTE_DOCUMENT_ACTION = exports.PROMOTE_DOCUMENT_ACTION = {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.promoteButtonLabel', {
    defaultMessage: 'Promote this result'
  }),
  iconType: 'starPlusEmpty',
  iconColor: 'primary'
};
const DEMOTE_DOCUMENT_ACTION = exports.DEMOTE_DOCUMENT_ACTION = {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.demoteButtonLabel', {
    defaultMessage: 'Demote this result'
  }),
  iconType: 'starMinusFilled',
  iconColor: 'primary'
};
const HIDE_DOCUMENT_ACTION = exports.HIDE_DOCUMENT_ACTION = {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.hideButtonLabel', {
    defaultMessage: 'Hide this result'
  }),
  iconType: 'eyeClosed',
  iconColor: 'danger'
};
const SHOW_DOCUMENT_ACTION = exports.SHOW_DOCUMENT_ACTION = {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.showButtonLabel', {
    defaultMessage: 'Show this result'
  }),
  iconType: 'eye',
  iconColor: 'primary'
};
const AUTOMATED_LABEL = exports.AUTOMATED_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.automatedLabel', {
  defaultMessage: 'Automated'
});
const COVERT_TO_MANUAL_BUTTON_LABEL = exports.COVERT_TO_MANUAL_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.convertToManualCurationButtonLabel', {
  defaultMessage: 'Convert to manual curation'
});