"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppSearchGate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _app_search_gate_logic = require("./app_search_gate_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const featuresList = {
  webCrawler: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.webCrawler.featureButtonLabel', {
      defaultMessage: 'Try Open Crawler'
    }),
    actionLink: 'https://github.com/elastic/crawler?tab=readme-ov-file#setup',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.webCrawler.featureDescription', {
      defaultMessage: 'Ingest web content into Elasticsearch using a web crawler'
    }),
    id: 'webCrawler',
    learnMore: 'https://github.com/elastic/crawler#readme ',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.webCrawler.panelText', {
      defaultMessage: 'Did you know the new self-managed Elastic open crawler is now available? You can keep your web content in sync with your search-optimized indices!'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.webCrawler.featureName', {
      defaultMessage: 'Web crawler'
    })
  },
  analyticsAndLogs: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.analyticsAndLogs.featureButtonLabel', {
      defaultMessage: 'Add search analytics'
    }),
    actionLink: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/behavioral-analytics-event.html',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.analyticsAndLogs.featureDescription', {
      defaultMessage: 'Add and view analytics and logs for your search application'
    }),
    id: 'analyticsAndLogs',
    learnMore: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/behavioral-analytics-overview.html',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.analyticsAndLogs.panelText', {
      defaultMessage: "You can track and analyze users' searching and clicking behavior with Behavioral Analytics. Instrument your website or application to track relevant user actions."
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.analyticsAndLogs.featureName', {
      defaultMessage: 'Search analytics and logs'
    })
  },
  synonyms: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.synonyms.featureButtonLabel', {
      defaultMessage: 'Search with synonyms'
    }),
    actionLink: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/synonyms-apis.html',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.synonyms.featureDescription', {
      defaultMessage: 'Perform search with synonym based query expansion'
    }),
    id: 'synonyms',
    learnMore: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-with-synonyms.html',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.synonyms.panelText', {
      defaultMessage: 'Use the Elasticsearch Synonyms APIs to easily create and manage synonym sets.'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.synonyms.featureName', {
      defaultMessage: 'Search with synonyms'
    })
  },
  relevanceTuning: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.relevanceTuning.featureButtonLabel', {
      defaultMessage: 'Tune search relevancy'
    }),
    actionLink: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-with-elasticsearch.html',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.relevanceTuning.featureDescription', {
      defaultMessage: 'Tune the relevancy of your results using ranking and boosting methods'
    }),
    id: 'relevanceTuning',
    learnMore: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-boosting-query.html',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.relevanceTuning.panelText', {
      defaultMessage: "Elasticsearch's query DSL provides an in-depth set of relevance tools."
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.relevanceTuning.featureName', {
      defaultMessage: 'Relevance tuning'
    })
  },
  curations: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.curations.featureButtonLabel', {
      defaultMessage: 'Use query rules'
    }),
    actionLink: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-using-query-rules.html',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.curations.featureDescription', {
      defaultMessage: 'Curate and pin results for specific queries'
    }),
    id: 'curations',
    learnMore: 'https://www.elastic.co/blog/introducing-query-rules-elasticsearch-8-10',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.curations.panelText', {
      defaultMessage: 'Query rules provide a more robust set of tools to customize your search results for queries that match specific criteria and metadata.'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.curations.featureName', {
      defaultMessage: 'Curate results'
    })
  },
  searchManagementUis: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.searchManagementUis.featureButtonLabel', {
      defaultMessage: 'Build a search experience with Search UI'
    }),
    actionLink: 'https://www.elastic.co/docs/current/search-ui/overview',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.searchManagementUis.featureDescription', {
      defaultMessage: 'Use graphical user interfaces (GUIs) to manage your search application experience'
    }),
    id: 'searchManagementUis',
    learnMore: 'https://www.elastic.co/docs/current/search-ui/tutorials/elasticsearch',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.searchManagementUis.panelText', {
      defaultMessage: 'Search UI provides the components needed to build a modern search experience.'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.searchManagementUis.featureName', {
      defaultMessage: 'Search and management UIs'
    })
  },
  credentials: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.credentials.featureButtonLabel', {
      defaultMessage: 'Secure with Elasticsearch'
    }),
    actionLink: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/document-level-security.html',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.credentials.featureDescription', {
      defaultMessage: 'Manage your users and roles, and credentials for accessing your search endpoints'
    }),
    id: 'credentials',
    learnMore: 'https://www.elastic.co/search-labs/blog/dls-internal-knowledge-search',
    panelText: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.credentials.panelText', {
      defaultMessage: 'Elasticsearch provides a comprehensive set of security features, including document-level security and role-based access control.'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.credentials.featureName', {
      defaultMessage: 'Credentials and roles'
    })
  }
};
const getFeature = id => {
  switch (id) {
    case featuresList.webCrawler.id:
      return featuresList.webCrawler;
    case featuresList.analyticsAndLogs.id:
      return featuresList.analyticsAndLogs;
    case featuresList.synonyms.id:
      return featuresList.synonyms;
    case featuresList.relevanceTuning.id:
      return featuresList.relevanceTuning;
    case featuresList.curations.id:
      return featuresList.curations;
    case featuresList.searchManagementUis.id:
      return featuresList.searchManagementUis;
    case featuresList.credentials.id:
      return featuresList.credentials;
    default:
      return undefined;
  }
};
const getOptionsFeaturesList = () => {
  const baseTranslatePrefix = 'xpack.enterpriseSearch.appSearch.gateForm.superSelect';
  const featureList = Object.keys(featuresList).map(featureKey => {
    const feature = getFeature(featureKey);
    if (!feature) {
      return {
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
        inputDisplay: '',
        value: ''
      };
    }
    return {
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, feature.title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, feature.description))),
      inputDisplay: feature.title,
      value: feature.id
    };
  });
  featureList.push({
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate(`${baseTranslatePrefix}.other.title`, {
      defaultMessage: 'Other'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate(`${baseTranslatePrefix}.other.description`, {
      defaultMessage: 'Another feature not listed here'
    })))),
    inputDisplay: _i18n.i18n.translate(`${baseTranslatePrefix}.other.inputDisplay`, {
      defaultMessage: 'Other'
    }),
    value: 'other'
  });
  return featureList;
};
const participateInUXLabsChoice = {
  no: {
    choice: 'no',
    value: false
  },
  yes: {
    choice: 'yes',
    value: true
  }
};
const EducationPanel = ({
  featureContent
}) => {
  const feature = getFeature(featureContent);
  const {
    setFeaturesOther
  } = (0, _kea.useActions)(_app_search_gate_logic.AppSearchGateLogic);
  if (feature) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.educationalPanel.title', {
      defaultMessage: 'Elasticsearch native equivalent'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.educationalPanel.subTitle', {
      defaultMessage: 'Based on your selection we recommend:'
    }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: feature.title,
      color: "success",
      iconType: "checkInCircleFilled"
    }, /*#__PURE__*/_react.default.createElement("p", null, feature.panelText), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      wrap: true,
      alignItems: "baseline"
    }, feature.actionLink !== undefined && feature.actionLabel !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: feature.actionLink,
      target: "_blank",
      iconType: "sortRight",
      iconSide: "right"
    }, feature.actionLabel)), feature.learnMore !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: feature.learnMore,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.educationalPanel.learnMore', {
      defaultMessage: 'Learn more'
    }))), feature.addOnLearnMoreLabel !== undefined && feature.addOnLearnMoreUrl !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      type: "button",
      href: feature.addOnLearnMoreUrl,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), feature.addOnLearnMoreLabel)))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.featureOther.Label', {
        defaultMessage: "Can you explain what other feature(s) you're looking for?"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      onChange: e => {
        setFeaturesOther(e.target.value);
      }
    })));
  }
};
const AppSearchGate = () => {
  var _feature;
  const {
    feature,
    participateInUXLabs
  } = (0, _kea.useValues)(_app_search_gate_logic.AppSearchGateLogic);
  const {
    formSubmitRequest,
    setAdditionalFeedback,
    setParticipateInUXLabs,
    setFeature
  } = (0, _kea.useActions)(_app_search_gate_logic.AppSearchGateLogic);
  const onSubmitForm = (0, _react.useCallback)(e => {
    e.preventDefault();
    formSubmitRequest();
  }, []);
  const options = getOptionsFeaturesList();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: onSubmitForm
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.features.Label', {
    defaultMessage: 'What App Search feature are you looking to use?'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: feature,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.features.selectOption', {
      defaultMessage: 'Select an option'
    }),
    onChange: value => setFeature(value),
    itemLayoutAlign: "top",
    hasDividers: true,
    fullWidth: true
  }), feature && /*#__PURE__*/_react.default.createElement(EducationPanel, {
    featureContent: feature
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.additionalFeedback.Label', {
      defaultMessage: 'Would you like to share any additional feedback?'
    }),
    labelAppend: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.additionalFeedback.optionalLabel', {
      defaultMessage: 'Optional'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    onChange: e => {
      setAdditionalFeedback(e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.gateForm.additionalFeedback.description",
    defaultMessage: " By submitting feedback you acknowledge that you've read and agree to our {termsOfService}, and that Elastic may {contact} about our related products and services, using the details you provide above. See {privacyStatementLink} for more details or to opt-out at any time.",
    values: {
      contact: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchGatedFormDataUse
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.contact",
        defaultMessage: "contact you"
      })),
      privacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchGatedFormPrivacyStatement
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.readDataPrivacyStatementLink",
        defaultMessage: "Elastic\u2019s Privacy Statement"
      })),
      termsOfService: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchGatedFormTermsOfService
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.readTermsOfService",
        defaultMessage: "Terms of Service"
      }))
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    labelAppend: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.participateUxLab.optionalLabel', {
      defaultMessage: 'Optional'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.participateUxLab.Label', {
      defaultMessage: 'Join our user research studies to improve Elasticsearch?'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    hasNoInitialSelection: participateInUXLabs === null,
    options: [{
      text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.participateUxLab.Label.Yes', {
        defaultMessage: 'Yes'
      }),
      value: participateInUXLabsChoice.yes.choice
    }, {
      text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.participateUxLab.Label.No', {
        defaultMessage: 'No'
      }),
      value: participateInUXLabsChoice.no.choice
    }],
    onChange: e => setParticipateInUXLabs(e.target.value === participateInUXLabsChoice.yes.choice ? participateInUXLabsChoice.yes.value : participateInUXLabsChoice.no.value),
    value: participateInUXLabs !== null ? participateInUXLabs ? participateInUXLabsChoice.yes.choice : participateInUXLabsChoice.no.choice : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: (_feature = !feature) !== null && _feature !== void 0 ? _feature : false,
    type: "submit",
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.submit', {
    defaultMessage: 'Submit'
  }))))));
};
exports.AppSearchGate = AppSearchGate;