"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticAssistantSharedStatePublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticAssistantSharedState = require("@kbn/elastic-assistant-shared-state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ElasticAssistantSharedStatePublicPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "commentService", void 0);
    (0, _defineProperty2.default)(this, "promptContextService", void 0);
    (0, _defineProperty2.default)(this, "assistantContextValueService", void 0);
    (0, _defineProperty2.default)(this, "augmentMessageCodeBlocksService", void 0);
    (0, _defineProperty2.default)(this, "signalIndexService", void 0);
    this.commentService = new _elasticAssistantSharedState.CommentsService();
    this.promptContextService = new _elasticAssistantSharedState.PromptContextService();
    this.assistantContextValueService = new _elasticAssistantSharedState.AssistantContextValueService();
    this.augmentMessageCodeBlocksService = new _elasticAssistantSharedState.AugmentMessageCodeBlocksService();
    this.signalIndexService = new _elasticAssistantSharedState.SignalIndexService();
  }
  setup(core) {
    return {};
  }
  start() {
    const comments = this.commentService.start();
    const promptContexts = this.promptContextService.start();
    const assistantContextValue = this.assistantContextValueService.start();
    const augmentMessageCodeBlocks = this.augmentMessageCodeBlocksService.start();
    const signalIndex = this.signalIndexService.start();
    return {
      comments,
      promptContexts,
      assistantContextValue,
      augmentMessageCodeBlocks,
      signalIndex
    };
  }
  stop() {
    this.commentService.stop();
    this.promptContextService.stop();
    this.assistantContextValueService.stop();
    this.augmentMessageCodeBlocksService.stop();
    this.signalIndexService.stop();
  }
}
exports.ElasticAssistantSharedStatePublicPlugin = ElasticAssistantSharedStatePublicPlugin;