"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertAlertingRuleToSchedule = void 0;
var _create_schedule_execution_summary = require("./create_schedule_execution_summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertAlertingRuleToSchedule = rule => {
  const {
    id,
    name,
    createdBy,
    updatedBy,
    createdAt,
    updatedAt,
    enabled,
    params,
    schedule,
    actions,
    systemActions
  } = rule;
  return {
    id,
    name,
    createdBy: createdBy !== null && createdBy !== void 0 ? createdBy : 'elastic',
    updatedBy: updatedBy !== null && updatedBy !== void 0 ? updatedBy : 'elastic',
    createdAt: createdAt.toISOString(),
    updatedAt: updatedAt.toISOString(),
    enabled,
    params,
    schedule,
    actions: [...actions, ...(systemActions !== null && systemActions !== void 0 ? systemActions : [])],
    lastExecution: (0, _create_schedule_execution_summary.createScheduleExecutionSummary)(rule)
  };
};
exports.convertAlertingRuleToSchedule = convertAlertingRuleToSchedule;