"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryScheduleDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _convert_alerting_rule_to_schedule = require("../../../../routes/attack_discovery/schedules/utils/convert_alerting_rule_to_schedule");
var _transform_actions = require("./utils/transform_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Params for when creating AttackDiscoveryScheduleDataClient in Request Context Factory. Useful if needing to modify
 * configuration after initial plugin start
 */

class AttackDiscoveryScheduleDataClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "findSchedules", async ({
      page = 0,
      perPage,
      sort: sortParam = {}
    } = {}) => {
      // TODO: add filtering
      const results = await this.options.rulesClient.find({
        options: {
          page: page + 1,
          perPage,
          sortField: sortParam.sortField,
          sortOrder: sortParam.sortDirection,
          ruleTypeIds: [_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID]
        }
      });
      const {
        total,
        data
      } = results;
      const schedules = data.map(_convert_alerting_rule_to_schedule.convertAlertingRuleToSchedule);
      return {
        total,
        data: schedules
      };
    });
    (0, _defineProperty2.default)(this, "getSchedule", async id => {
      const rule = await this.options.rulesClient.get({
        id
      });
      const schedule = (0, _convert_alerting_rule_to_schedule.convertAlertingRuleToSchedule)(rule);
      return schedule;
    });
    (0, _defineProperty2.default)(this, "createSchedule", async ruleToCreate => {
      const {
        enabled = false,
        actions: _,
        ...restScheduleAttributes
      } = ruleToCreate;
      const {
        actions,
        systemActions
      } = (0, _transform_actions.convertScheduleActionsToAlertingActions)({
        actionsClient: this.options.actionsClient,
        logger: this.options.logger,
        scheduleActions: ruleToCreate.actions
      });
      const rule = await this.options.rulesClient.create({
        data: {
          actions,
          ...(systemActions.length ? {
            systemActions
          } : {}),
          alertTypeId: _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID,
          consumer: _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_CONSUMER_ID,
          enabled,
          tags: [],
          ...restScheduleAttributes
        }
      });
      const schedule = (0, _convert_alerting_rule_to_schedule.convertAlertingRuleToSchedule)(rule);
      return schedule;
    });
    (0, _defineProperty2.default)(this, "updateSchedule", async ruleToUpdate => {
      const {
        id,
        actions: _,
        ...updatePayload
      } = ruleToUpdate;
      const {
        actions,
        systemActions
      } = (0, _transform_actions.convertScheduleActionsToAlertingActions)({
        actionsClient: this.options.actionsClient,
        logger: this.options.logger,
        scheduleActions: ruleToUpdate.actions
      });
      const rule = await this.options.rulesClient.update({
        id,
        data: {
          actions,
          ...(systemActions.length ? {
            systemActions
          } : {}),
          tags: [],
          ...updatePayload
        }
      });
      const schedule = (0, _convert_alerting_rule_to_schedule.convertAlertingRuleToSchedule)(rule);
      return schedule;
    });
    (0, _defineProperty2.default)(this, "deleteSchedule", async ruleToDelete => {
      await this.options.rulesClient.delete(ruleToDelete);
    });
    (0, _defineProperty2.default)(this, "enableSchedule", async ruleToEnable => {
      await this.options.rulesClient.enableRule(ruleToEnable);
    });
    (0, _defineProperty2.default)(this, "disableSchedule", async ruleToDisable => {
      await this.options.rulesClient.disableRule(ruleToDisable);
    });
    this.options = options;
  }
}
exports.AttackDiscoveryScheduleDataClient = AttackDiscoveryScheduleDataClient;