"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscovery = void 0;
var _transforms = require("../transforms/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAttackDiscovery = async ({
  esClient,
  logger,
  attackDiscoveryIndex,
  id,
  user
}) => {
  const filterByUser = [{
    nested: {
      path: 'users',
      query: {
        bool: {
          must: [{
            match: user.profile_uid ? {
              'users.id': user.profile_uid
            } : {
              'users.name': user.username
            }
          }]
        }
      }
    }
  }];
  try {
    var _attackDiscovery$;
    const response = await esClient.search({
      query: {
        bool: {
          must: [{
            bool: {
              should: [{
                term: {
                  _id: id
                }
              }]
            }
          }, ...filterByUser]
        }
      },
      _source: true,
      ignore_unavailable: true,
      index: attackDiscoveryIndex,
      seq_no_primary_term: true
    });
    const attackDiscovery = (0, _transforms.transformESSearchToAttackDiscovery)(response);
    return (_attackDiscovery$ = attackDiscovery[0]) !== null && _attackDiscovery$ !== void 0 ? _attackDiscovery$ : null;
  } catch (err) {
    logger.error(`Error fetching attack discovery: ${err} with id: ${id}`);
    throw err;
  }
};
exports.getAttackDiscovery = getAttackDiscovery;