"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultGraphAnnotation = void 0;
var _langgraph = require("@langchain/langgraph");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultGraphAnnotation = ({
  end,
  filter,
  prompts,
  start
}) => _langgraph.Annotation.Root({
  attackDiscoveries: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => null
  }),
  attackDiscoveryPrompt: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => prompts.default
  }),
  anonymizedAlerts: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  }),
  combinedGenerations: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  }),
  combinedRefinements: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  }),
  continuePrompt: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => prompts.continue
  }),
  end: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => end
  }),
  errors: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  }),
  filter: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => filter
  }),
  generationAttempts: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 0
  }),
  generations: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  }),
  hallucinationFailures: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 0
  }),
  refinePrompt: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => prompts.refine
  }),
  maxGenerationAttempts: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => _constants.DEFAULT_MAX_GENERATION_ATTEMPTS
  }),
  maxHallucinationFailures: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => _constants.DEFAULT_MAX_HALLUCINATION_FAILURES
  }),
  maxRepeatedGenerations: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => _constants.DEFAULT_MAX_REPEATED_GENERATIONS
  }),
  refinements: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  }),
  replacements: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  }),
  start: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => start
  }),
  unrefinedResults: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => null
  })
});
exports.getDefaultGraphAnnotation = getDefaultGraphAnnotation;