"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindPromptsSortFieldEnum = exports.FindPromptsSortField = exports.FindPromptsResponse = exports.FindPromptsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../common_attributes.gen");
var _bulk_crud_prompts_route = require("./bulk_crud_prompts_route.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Prompts API endpoint
 *   version: 2023-10-31
 */

/**
 * Field by which to sort the prompts.
 */

const FindPromptsSortField = exports.FindPromptsSortField = _zod.z.enum(['created_at', 'is_default', 'name', 'updated_at']);
const FindPromptsSortFieldEnum = exports.FindPromptsSortFieldEnum = FindPromptsSortField.enum;
const FindPromptsRequestQuery = exports.FindPromptsRequestQuery = _zod.z.object({
  /**
   * List of specific fields to include in each returned prompt.
   */
  fields: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Search query string to filter prompts by matching fields.
   */
  filter: _zod.z.string().optional(),
  /**
   * Field to sort prompts by.
   */
  sort_field: FindPromptsSortField.optional(),
  /**
   * Sort order, either asc or desc.
   */
  sort_order: _common_attributes.SortOrder.optional(),
  /**
   * Page number for pagination.
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Number of prompts per page.
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
});
const FindPromptsResponse = exports.FindPromptsResponse = _zod.z.object({
  /**
   * Current page number.
   */
  page: _zod.z.number().int(),
  /**
   * Number of prompts per page.
   */
  perPage: _zod.z.number().int(),
  /**
   * Total number of prompts matching the query.
   */
  total: _zod.z.number().int(),
  /**
   * The list of prompts returned based on the search query, sorting, and pagination.
   */
  data: _zod.z.array(_bulk_crud_prompts_route.PromptResponse)
});