"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptsBulkCrudActionResults = exports.PromptsBulkCrudActionResponse = exports.PromptsBulkActionSkipResult = exports.PromptsBulkActionSkipReason = exports.PromptUpdateProps = exports.PromptTypeEnum = exports.PromptType = exports.PromptResponse = exports.PromptDetailsInError = exports.PromptCreateProps = exports.PerformPromptsBulkActionResponse = exports.PerformPromptsBulkActionRequestBody = exports.NormalizedPromptError = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Prompts Actions API endpoint
 *   version: 2023-10-31
 */

/**
 * Reason why a prompt was skipped during the bulk action.
 */

const PromptsBulkActionSkipReason = exports.PromptsBulkActionSkipReason = _zod.z.literal('PROMPT_FIELD_NOT_MODIFIED');
const PromptsBulkActionSkipResult = exports.PromptsBulkActionSkipResult = _zod.z.object({
  /**
   * The ID of the prompt that was skipped.
   */
  id: _zod.z.string(),
  /**
   * The name of the prompt that was skipped.
   */
  name: _zod.z.string().optional(),
  /**
   * The reason for skipping the prompt.
   */
  skip_reason: PromptsBulkActionSkipReason
});
const PromptDetailsInError = exports.PromptDetailsInError = _zod.z.object({
  /**
   * The ID of the prompt that encountered an error.
   */
  id: _zod.z.string(),
  /**
   * The name of the prompt that encountered an error.
   */
  name: _zod.z.string().optional()
});

/**
 * Type of the prompt (either system or quick).
 */

const PromptType = exports.PromptType = _zod.z.enum(['system', 'quick']);
const PromptTypeEnum = exports.PromptTypeEnum = PromptType.enum;
const NormalizedPromptError = exports.NormalizedPromptError = _zod.z.object({
  /**
   * A message describing the error encountered.
   */
  message: _zod.z.string(),
  /**
   * The HTTP status code associated with the error.
   */
  status_code: _zod.z.number().int(),
  /**
   * A code representing the error type.
   */
  err_code: _zod.z.string().optional(),
  /**
   * List of prompts that encountered errors.
   */
  prompts: _zod.z.array(PromptDetailsInError)
});
const PromptResponse = exports.PromptResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyTimestamp.optional(),
  /**
   * The name of the prompt.
   */
  name: _zod.z.string(),
  /**
   * The type of the prompt.
   */
  promptType: PromptType,
  /**
   * The content of the prompt.
   */
  content: _zod.z.string(),
  /**
   * Categories associated with the prompt.
   */
  categories: _zod.z.array(_zod.z.string()).optional(),
  /**
   * The color associated with the prompt.
   */
  color: _zod.z.string().optional(),
  /**
   * Whether this prompt is the default for new conversations.
   */
  isNewConversationDefault: _zod.z.boolean().optional(),
  /**
   * Whether this prompt is the default.
   */
  isDefault: _zod.z.boolean().optional(),
  /**
   * The consumer that the prompt is associated with.
   */
  consumer: _zod.z.string().optional(),
  /**
   * The timestamp of when the prompt was last updated.
   */
  updatedAt: _zod.z.string().optional(),
  /**
   * The user who last updated the prompt.
   */
  updatedBy: _zod.z.string().optional(),
  /**
   * The timestamp of when the prompt was created.
   */
  createdAt: _zod.z.string().optional(),
  /**
   * The user who created the prompt.
   */
  createdBy: _zod.z.string().optional(),
  /**
   * List of users associated with the prompt.
   */
  users: _zod.z.array(_common_attributes.User).optional(),
  /**
   * Kibana space where the prompt is located.
   */
  namespace: _zod.z.string().optional()
});
const PromptsBulkCrudActionResults = exports.PromptsBulkCrudActionResults = _zod.z.object({
  /**
   * List of prompts that were updated.
   */
  updated: _zod.z.array(PromptResponse),
  /**
   * List of prompts that were created.
   */
  created: _zod.z.array(PromptResponse),
  /**
   * List of IDs of prompts that were deleted.
   */
  deleted: _zod.z.array(_zod.z.string()),
  /**
   * List of prompts that were skipped.
   */
  skipped: _zod.z.array(PromptsBulkActionSkipResult)
});
const PromptsBulkCrudActionResponse = exports.PromptsBulkCrudActionResponse = _zod.z.object({
  /**
   * Indicates if the bulk action was successful.
   */
  success: _zod.z.boolean().optional(),
  /**
   * The HTTP status code of the response.
   */
  status_code: _zod.z.number().int().optional(),
  /**
   * A message describing the result of the bulk action.
   */
  message: _zod.z.string().optional(),
  /**
   * The number of prompts processed in the bulk action.
   */
  prompts_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: PromptsBulkCrudActionResults,
    summary: _common_attributes.BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedPromptError).optional()
  })
});
const PromptCreateProps = exports.PromptCreateProps = _zod.z.object({
  /**
   * The name of the prompt.
   */
  name: _zod.z.string(),
  /**
   * The type of the prompt.
   */
  promptType: PromptType,
  /**
   * The content of the prompt.
   */
  content: _zod.z.string(),
  /**
   * The color associated with the prompt.
   */
  color: _zod.z.string().optional(),
  /**
   * List of categories for the prompt.
   */
  categories: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Whether this prompt should be the default for new conversations.
   */
  isNewConversationDefault: _zod.z.boolean().optional(),
  /**
   * Whether this prompt should be the default.
   */
  isDefault: _zod.z.boolean().optional(),
  /**
   * The consumer associated with the prompt.
   */
  consumer: _zod.z.string().optional()
});
const PromptUpdateProps = exports.PromptUpdateProps = _zod.z.object({
  /**
   * The ID of the prompt to update.
   */
  id: _zod.z.string(),
  /**
   * The updated content for the prompt.
   */
  content: _zod.z.string().optional(),
  /**
   * The updated color associated with the prompt.
   */
  color: _zod.z.string().optional(),
  /**
   * The updated categories for the prompt.
   */
  categories: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Whether the prompt should be the default for new conversations.
   */
  isNewConversationDefault: _zod.z.boolean().optional(),
  /**
   * Whether this prompt should be the default.
   */
  isDefault: _zod.z.boolean().optional(),
  /**
   * The updated consumer for the prompt.
   */
  consumer: _zod.z.string().optional()
});
const PerformPromptsBulkActionRequestBody = exports.PerformPromptsBulkActionRequestBody = _zod.z.object({
  /**
   * Criteria for deleting prompts in bulk.
   */
  delete: _common_attributes.BulkActionBase.optional(),
  /**
   * List of prompts to be created.
   */
  create: _zod.z.array(PromptCreateProps).optional(),
  /**
   * List of prompts to be updated.
   */
  update: _zod.z.array(PromptUpdateProps).optional()
});
const PerformPromptsBulkActionResponse = exports.PerformPromptsBulkActionResponse = PromptsBulkCrudActionResponse;