"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindConversationsSortFieldEnum = exports.FindConversationsSortField = exports.FindConversationsResponse = exports.FindConversationsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Conversations API endpoint
 *   version: 2023-10-31
 */

/**
 * The field by which to sort the conversations. Possible values are `created_at`, `title`, and `updated_at`.
 */

const FindConversationsSortField = exports.FindConversationsSortField = _zod.z.enum(['created_at', 'title', 'updated_at']);
const FindConversationsSortFieldEnum = exports.FindConversationsSortFieldEnum = FindConversationsSortField.enum;
const FindConversationsRequestQuery = exports.FindConversationsRequestQuery = _zod.z.object({
  /**
   * A list of fields to include in the response. If omitted, all fields are returned.
   */
  fields: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * A search query to filter the conversations. Can match against titles, messages, or other conversation attributes.
   */
  filter: _zod.z.string().optional(),
  /**
   * The field by which to sort the results. Valid fields are `created_at`, `title`, and `updated_at`.
   */
  sort_field: FindConversationsSortField.optional(),
  /**
   * The order in which to sort the results. Can be either `asc` for ascending or `desc` for descending.
   */
  sort_order: _common_attributes.SortOrder.optional(),
  /**
   * The page number of the results to retrieve. Default is 1.
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * The number of conversations to return per page. Default is 20.
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
});
const FindConversationsResponse = exports.FindConversationsResponse = _zod.z.object({
  /**
   * The current page of the results.
   */
  page: _zod.z.number().int(),
  /**
   * The number of results returned per page.
   */
  perPage: _zod.z.number().int(),
  /**
   * The total number of conversations matching the filter criteria.
   */
  total: _zod.z.number().int(),
  /**
   * A list of conversations.
   */
  data: _zod.z.array(_common_attributes2.ConversationResponse)
});