"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoredReason = void 0;
exports.getIgnoredReason = getIgnoredReason;
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let IgnoredReason = exports.IgnoredReason = /*#__PURE__*/function (IgnoredReason) {
  IgnoredReason["IGNORE_ABOVE"] = "ignore_above";
  IgnoredReason["MALFORMED"] = "malformed";
  IgnoredReason["UNKNOWN"] = "unknown";
  return IgnoredReason;
}({});
/**
 * Returns the reason why a specific field was ignored in the response.
 * Will return undefined if the field had no ignored values in it.
 * This implementation will make some assumptions based on specific types
 * of ignored values can only happen with specific field types in Elasticsearch.
 *
 * @param field Either the data view field or the string name of it.
 * @param ignoredFields The hit._ignored value of the hit to validate.
 */
function getIgnoredReason(field, ignoredFields) {
  const fieldName = typeof field === 'string' ? field : field.name;
  if (!(ignoredFields !== null && ignoredFields !== void 0 && ignoredFields.includes(fieldName))) {
    return undefined;
  }
  if (typeof field === 'string') {
    return IgnoredReason.UNKNOWN;
  }
  switch (field.type) {
    case _fieldTypes.KBN_FIELD_TYPES.STRING:
      return IgnoredReason.IGNORE_ABOVE;
    case _fieldTypes.KBN_FIELD_TYPES.NUMBER:
    case _fieldTypes.KBN_FIELD_TYPES.DATE:
    case _fieldTypes.KBN_FIELD_TYPES.GEO_POINT:
    case _fieldTypes.KBN_FIELD_TYPES.GEO_SHAPE:
    case _fieldTypes.KBN_FIELD_TYPES.IP:
      return IgnoredReason.MALFORMED;
    default:
      return IgnoredReason.UNKNOWN;
  }
}