"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reasonSectionTitle = exports.overviewTabTitle = exports.overviewExploreButtonLabel = exports.noEcsDescriptionReason = exports.exploreRowActionLabel = exports.ecsDescriptionLoadingAriaLable = exports.descriptionSectionTitle = exports.aboutSectionTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const exploreRowActionLabel = isAlert => _i18n.i18n.translate('discover.profile.security.rowAction.exploreButtonLabel', {
  values: {
    isAlert
  },
  defaultMessage: 'Explore {isAlert, select, true {Alert} other {Event}} in Security'
});
exports.exploreRowActionLabel = exploreRowActionLabel;
const overviewTabTitle = isAlert => _i18n.i18n.translate('discover.profile.security.flyout.overviewTabTitle', {
  values: {
    isAlert
  },
  defaultMessage: '{isAlert, select, true {Alert} other {Event}} Overview'
});
exports.overviewTabTitle = overviewTabTitle;
const overviewExploreButtonLabel = isAlert => _i18n.i18n.translate('discover.profile.security.flyout.overviewExploreButtonLabel', {
  values: {
    isAlert
  },
  defaultMessage: 'Explore in {isAlert, select, true {Alerts} other {Timeline}}'
});
exports.overviewExploreButtonLabel = overviewExploreButtonLabel;
const noEcsDescriptionReason = exports.noEcsDescriptionReason = _i18n.i18n.translate('discover.profile.security.flyout.noEventKindDescriptionMessage', {
  defaultMessage: "This field doesn't have a description because it's not part of ECS."
});
const aboutSectionTitle = exports.aboutSectionTitle = _i18n.i18n.translate('discover.profile.security.flyout.aboutSectionTitle', {
  defaultMessage: 'About'
});
const descriptionSectionTitle = exports.descriptionSectionTitle = _i18n.i18n.translate('discover.profile.security.flyout.descriptionSectionTitle', {
  defaultMessage: 'Description'
});
const reasonSectionTitle = exports.reasonSectionTitle = _i18n.i18n.translate('discover.profile.security.flyout.reasonSectionTitle', {
  defaultMessage: 'Reason'
});
const ecsDescriptionLoadingAriaLable = exports.ecsDescriptionLoadingAriaLable = _i18n.i18n.translate('discover.profile.security.flyout.ecsDescriptionLoadingAriaLabel', {
  defaultMessage: 'Loading ECS description'
});