"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityTracesTransactionDocumentProfileProvider = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../../../../common/constants");
var _profiles = require("../../../../profiles");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OBSERVABILITY_TRACES_TRANSACTION_DOCUMENT_PROFILE_ID = 'observability-traces-transaction-document-profile';
const createObservabilityTracesTransactionDocumentProfileProvider = ({
  tracesContextService,
  apmErrorsContextService,
  logsContextService
}) => {
  var _logsContextService$g;
  return {
    profileId: OBSERVABILITY_TRACES_TRANSACTION_DOCUMENT_PROFILE_ID,
    restrictedToProductFeature: _constants.TRACES_PRODUCT_FEATURE_ID,
    profile: {
      getDocViewer: (0, _accessors.createGetDocViewer)({
        apm: {
          errors: apmErrorsContextService.getErrorsIndexPattern(),
          traces: tracesContextService.getAllTracesIndexPattern()
        },
        logs: (_logsContextService$g = logsContextService.getAllLogsIndexPattern()) !== null && _logsContextService$g !== void 0 ? _logsContextService$g : ''
      })
    },
    resolve: ({
      record,
      rootContext
    }) => {
      const isObservabilitySolutionView = rootContext.solutionType === _profiles.SolutionType.Observability;
      if (!isObservabilitySolutionView) {
        return {
          isMatch: false
        };
      }
      const isTransactionRecord = getIsTransactionRecord({
        record
      });
      if (!isTransactionRecord) {
        return {
          isMatch: false
        };
      }
      return {
        isMatch: true,
        context: {
          type: _profiles.DocumentType.Transaction
        }
      };
    }
  };
};
exports.createObservabilityTracesTransactionDocumentProfileProvider = createObservabilityTracesTransactionDocumentProfileProvider;
const getIsTransactionRecord = ({
  record
}) => {
  return isTransactionDocument(record);
};
const isTransactionDocument = record => {
  const dataStreamType = (0, _discoverUtils.getFieldValue)(record, _discoverUtils.DATASTREAM_TYPE_FIELD);
  const processorEvent = (0, _discoverUtils.getFieldValue)(record, _discoverUtils.PROCESSOR_EVENT_FIELD);
  return dataStreamType === 'traces' && processorEvent === 'transaction';
};