"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogsExplorerTabs = void 0;
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _common = require("../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const emptyParams = {};
const LogsExplorerTabs = ({
  services,
  selectedTab
}) => {
  var _services$share;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const locators = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators;
  const discoverLocator = locators === null || locators === void 0 ? void 0 : locators.get(_common.DISCOVER_APP_LOCATOR);
  const logsExplorerLocator = locators === null || locators === void 0 ? void 0 : locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
  const discoverUrl = discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl(emptyParams);
  const logsExplorerUrl = logsExplorerLocator === null || logsExplorerLocator === void 0 ? void 0 : logsExplorerLocator.getRedirectUrl(emptyParams);
  const [lastUsedViewer, setLastUsedViewer] = (0, _useLocalStorage.default)(_deeplinksObservability.OBS_LOGS_EXPLORER_LOGS_VIEWER_KEY, _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID);
  const navigateToDiscover = createNavigateHandler(() => {
    if (selectedTab !== 'discover') {
      discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.navigate(emptyParams);
    }
  });
  const navigateToLogsExplorer = createNavigateHandler(() => {
    if (selectedTab !== 'logs-explorer') {
      logsExplorerLocator === null || logsExplorerLocator === void 0 ? void 0 : logsExplorerLocator.navigate(emptyParams);
    }
  });
  (0, _react.useEffect)(() => {
    if (selectedTab === 'discover' && lastUsedViewer !== _deeplinksAnalytics.DISCOVER_APP_ID) {
      setLastUsedViewer(_deeplinksAnalytics.DISCOVER_APP_ID);
    }
    if (selectedTab === 'logs-explorer' && lastUsedViewer !== _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID) {
      setLastUsedViewer(_deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID);
    }
  }, [setLastUsedViewer, lastUsedViewer, selectedTab]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    "data-test-subj": "logsExplorerTabs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'discover',
    href: discoverUrl,
    onClick: navigateToDiscover,
    css: {
      '.euiTab__content': {
        lineHeight: euiTheme.size.xxxl
      }
    },
    "data-test-subj": "discoverTab"
  }, _i18n.i18n.translate('discover.logsExplorerTabs.discover', {
    defaultMessage: 'Discover'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'logs-explorer',
    href: logsExplorerUrl,
    onClick: navigateToLogsExplorer,
    css: {
      '.euiTab__content': {
        lineHeight: euiTheme.size.xxxl
      }
    },
    "data-test-subj": "logsExplorerTab"
  }, _i18n.i18n.translate('discover.logsExplorerTabs.logsExplorer', {
    defaultMessage: 'Logs Explorer'
  })));
};

// eslint-disable-next-line import/no-default-export
exports.LogsExplorerTabs = LogsExplorerTabs;
var _default = exports.default = LogsExplorerTabs;
const isModifiedEvent = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey;
const isLeftClickEvent = event => event.button === 0;
const createNavigateHandler = onClick => e => {
  if (isModifiedEvent(e) || !isLeftClickEvent(e)) {
    return;
  }
  e.preventDefault();
  onClick();
};