"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HitsCounterMode = exports.HitsCounter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _types = require("../../application/types");
var _use_data_state = require("../../application/main/hooks/use_data_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let HitsCounterMode = exports.HitsCounterMode = /*#__PURE__*/function (HitsCounterMode) {
  HitsCounterMode["standalone"] = "standalone";
  HitsCounterMode["appended"] = "appended";
  return HitsCounterMode;
}({});
const HitsCounter = ({
  mode,
  stateContainer
}) => {
  var _documentsState$resul, _hitsTotal, _hitsTotal2;
  const totalHits$ = stateContainer.dataState.data$.totalHits$;
  const totalHitsState = (0, _use_data_state.useDataState)(totalHits$);
  let hitsTotal = totalHitsState.result;
  const hitsStatus = totalHitsState.fetchStatus;
  const documents$ = stateContainer.dataState.data$.documents$;
  const documentsState = (0, _use_data_state.useDataState)(documents$);
  const documentsCount = ((_documentsState$resul = documentsState.result) === null || _documentsState$resul === void 0 ? void 0 : _documentsState$resul.length) || 0;
  if (!hitsTotal && hitsStatus === _types.FetchStatus.LOADING) {
    return null;
  }
  if (hitsStatus === _types.FetchStatus.ERROR && documentsState.fetchStatus === _types.FetchStatus.COMPLETE && documentsCount > ((_hitsTotal = hitsTotal) !== null && _hitsTotal !== void 0 ? _hitsTotal : 0)) {
    // if histogram returned partial results and which are less than the fetched documents count =>
    // override hitsTotal with the fetched documents count
    hitsTotal = documentsCount;
  }
  const showGreaterOrEqualSign = hitsStatus === _types.FetchStatus.PARTIAL || hitsStatus === _types.FetchStatus.ERROR;
  const formattedHits = /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": showGreaterOrEqualSign ? 'discoverQueryHitsPartial' : 'discoverQueryHits'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: (_hitsTotal2 = hitsTotal) !== null && _hitsTotal2 !== void 0 ? _hitsTotal2 : 0
  }));
  const hitsCounterCss = (0, _react2.css)`
    display: inline-flex;
  `;
  const hitsCounterTextCss = (0, _react2.css)`
    overflow: hidden;
  `;
  const element = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    justifyContent: "center",
    alignItems: "center",
    className: "eui-textTruncate eui-textNoWrap",
    css: hitsCounterCss,
    "data-test-subj": "discoverQueryTotalHits"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "aria-live": "polite",
    css: hitsCounterTextCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textTruncate",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, showGreaterOrEqualSign ? mode === HitsCounterMode.standalone ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.hitsCounter.partialHitsPluralTitle",
    defaultMessage: "\u2265{formattedHits} {hits, plural, one {result} other {results}}",
    values: {
      hits: hitsTotal,
      formattedHits
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.hitsCounter.partialHits",
    defaultMessage: "\u2265{formattedHits}",
    values: {
      formattedHits
    }
  }) : mode === HitsCounterMode.standalone ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.hitsCounter.hitsPluralTitle",
    defaultMessage: "{formattedHits} {hits, plural, one {result} other {results}}",
    values: {
      hits: hitsTotal,
      formattedHits
    }
  }) : formattedHits))), hitsStatus === _types.FetchStatus.PARTIAL && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "aria-label": _i18n.i18n.translate('discover.hitsCounter.hitCountSpinnerAriaLabel', {
      defaultMessage: 'Final hit count still loading'
    })
  })), hitsStatus === _types.FetchStatus.ERROR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: "warning",
    size: "s",
    content: _i18n.i18n.translate('discover.hitsCounter.hitCountWarningTooltip', {
      defaultMessage: 'Results might be incomplete'
    }),
    iconProps: {
      css: {
        display: 'block'
      }
    }
  })));
  return mode === HitsCounterMode.appended ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' (', element, ')') : element;
};
exports.HitsCounter = HitsCounter;