"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _searchErrors = require("@kbn/search-errors");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ErrorCallout = ({
  title,
  error,
  isEsqlMode
}) => {
  var _searchErrorDisplay$t, _searchErrorDisplay$a, _searchErrorDisplay$b;
  const {
    core,
    docLinks
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const searchErrorDisplay = (0, _searchErrors.renderSearchError)(error);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "error",
      color: "danger"
    }),
    color: "plain",
    paddingSize: "m",
    css: (0, _react.css)`
        margin: ${euiTheme.size.xl} auto;
      `,
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      "data-test-subj": "discoverErrorCalloutTitle"
    }, (_searchErrorDisplay$t = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.title) !== null && _searchErrorDisplay$t !== void 0 ? _searchErrorDisplay$t : title),
    titleSize: "xs",
    hasBorder: true,
    actions: (_searchErrorDisplay$a = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.actions) !== null && _searchErrorDisplay$a !== void 0 ? _searchErrorDisplay$a : [],
    body: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (_searchErrorDisplay$b = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.body) !== null && _searchErrorDisplay$b !== void 0 ? _searchErrorDisplay$b : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "s",
      language: "json",
      isCopyable: true,
      css: (0, _react.css)`
                  text-align: left;
                `,
      "data-test-subj": "discoverErrorCalloutMessage"
    }, error.message), !isEsqlMode && /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: () => core.notifications.showErrorDialog({
        title,
        error
      }),
      "data-test-subj": "discoverErrorCalloutShowDetailsButton"
    }, _i18n.i18n.translate('discover.errorCalloutShowErrorMessage', {
      defaultMessage: 'View details'
    })))),
    footer: isEsqlMode ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "documentation",
      href: docLinks.links.query.queryESQL,
      "data-test-subj": "discoverErrorCalloutESQLReferenceButton",
      target: "_blank"
    }, _i18n.i18n.translate('discover.errorCalloutESQLReferenceButtonLabel', {
      defaultMessage: 'Open ES|QL reference'
    })) : undefined
  });
};
exports.ErrorCallout = ErrorCallout;