"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAnchor = fetchAnchor;
exports.updateSearchSource = updateSearchSource;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/inspector-plugin/common");
var _discoverUtils = require("@kbn/discover-utils");
var _data_sources = require("../../../../common/data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function fetchAnchor(anchorId, dataView, searchSource, sort, useNewFieldsApi = false, services) {
  var _rawResponse$hits, _rawResponse$hits$hit;
  await services.profilesManager.resolveDataSourceProfile({
    dataSource: (0, _data_sources.createDataSource)({
      dataView,
      query: undefined
    }),
    dataView,
    query: {
      query: '',
      language: 'kuery'
    }
  });
  updateSearchSource(searchSource, anchorId, sort, useNewFieldsApi, dataView);
  const adapter = new _common.RequestAdapter();
  const {
    rawResponse
  } = await (0, _rxjs.lastValueFrom)(searchSource.fetch$({
    disableWarningToasts: true,
    inspector: {
      adapter,
      title: 'anchor'
    }
  }));
  const doc = (_rawResponse$hits = rawResponse.hits) === null || _rawResponse$hits === void 0 ? void 0 : (_rawResponse$hits$hit = _rawResponse$hits.hits) === null || _rawResponse$hits$hit === void 0 ? void 0 : _rawResponse$hits$hit[0];
  if (!doc) {
    throw new Error(_i18n.i18n.translate('discover.context.failedToLoadAnchorDocumentErrorDescription', {
      defaultMessage: 'Failed to load anchor document.'
    }));
  }
  const interceptedWarnings = [];
  services.data.search.showWarnings(adapter, warning => {
    interceptedWarnings.push(warning);
    return true; // suppress the default behaviour
  });
  return {
    anchorRow: services.profilesManager.resolveDocumentProfile({
      record: (0, _discoverUtils.buildDataTableRecord)(doc, dataView, true)
    }),
    interceptedWarnings
  };
}
function updateSearchSource(searchSource, anchorId, sort, useNewFieldsApi, dataView) {
  searchSource.setParent(undefined).setField('index', dataView).setField('version', true).setField('size', 1).setField('query', {
    query: {
      constant_score: {
        filter: {
          ids: {
            values: [anchorId]
          }
        }
      }
    },
    language: 'lucene'
  }).setField('sort', sort).setField('trackTotalHits', false);
  if (useNewFieldsApi) {
    searchSource.removeField('fieldsFromSource');
    searchSource.setField('fields', [{
      field: '*',
      include_unmapped: true
    }]);
  }
  return searchSource;
}