"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "datasetDetailsTrackingId", '');
    (0, _defineProperty2.default)(this, "startTime", 0);
    (0, _defineProperty2.default)(this, "datasetDetailsState", 'initial');
    (0, _defineProperty2.default)(this, "trackDatasetNavigated", eventProps => {
      this.analytics.reportEvent(_types.DatasetQualityTelemetryEventTypes.NAVIGATED, eventProps);
    });
    (0, _defineProperty2.default)(this, "trackDatasetDetailsOpened", eventProps => {
      const datasetDetailsLoadDuration = Date.now() - this.startTime;
      this.datasetDetailsState = 'opened';
      this.analytics.reportEvent(_types.DatasetQualityTelemetryEventTypes.DETAILS_OPENED, {
        ...eventProps,
        tracking_id: this.datasetDetailsTrackingId,
        duration: datasetDetailsLoadDuration
      });
    });
    (0, _defineProperty2.default)(this, "trackDatasetDetailsNavigated", eventProps => {
      this.datasetDetailsState = 'navigated';
      this.analytics.reportEvent(_types.DatasetQualityTelemetryEventTypes.DETAILS_NAVIGATED, {
        ...eventProps,
        tracking_id: this.datasetDetailsTrackingId
      });
    });
    (0, _defineProperty2.default)(this, "trackDatasetDetailsBreakdownFieldChanged", eventProps => {
      this.analytics.reportEvent(_types.DatasetQualityTelemetryEventTypes.BREAKDOWN_FIELD_CHANGED, {
        ...eventProps,
        tracking_id: this.datasetDetailsTrackingId
      });
    });
    this.analytics = analytics;
  }
  startDatasetDetailsTracking() {
    this.datasetDetailsTrackingId = (0, _uuid.v4)();
    this.startTime = Date.now();
    this.datasetDetailsState = 'started';
  }
  getDatasetDetailsTrackingState() {
    return this.datasetDetailsState;
  }
}
exports.TelemetryClient = TelemetryClient;