"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMappingLimit = FieldMappingLimit;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../../../../common/translations");
var _hooks = require("../../../../../../hooks");
var _increase_field_mapping_limit = require("./increase_field_mapping_limit");
var _field_limit_documentation_link = require("./field_limit_documentation_link");
var _message_callout = require("./message_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldMappingLimit({
  areIntegrationAssetsAvailable
}) {
  var _degradedFieldAnalysi;
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: _translations.increaseFieldMappingLimitTitle
  });
  const {
    degradedFieldAnalysis
  } = (0, _hooks.useQualityIssues)();
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, _translations.increaseFieldMappingLimitTitle));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    initialIsOpen: true,
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldLimitMitigationAccordion",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    component: "p"
  }, _translations.fieldLimitMitigationDescriptionText), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.fieldLimitMitigationConsiderationText), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, _translations.fieldLimitMitigationConsiderationText1), /*#__PURE__*/_react.default.createElement("li", null, _translations.fieldLimitMitigationConsiderationText2), /*#__PURE__*/_react.default.createElement("li", null, _translations.fieldLimitMitigationConsiderationText3), /*#__PURE__*/_react.default.createElement("li", null, _translations.fieldLimitMitigationConsiderationText4))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), areIntegrationAssetsAvailable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_increase_field_mapping_limit.IncreaseFieldMappingLimit, {
    totalFieldLimit: (_degradedFieldAnalysi = degradedFieldAnalysis === null || degradedFieldAnalysis === void 0 ? void 0 : degradedFieldAnalysis.totalFieldLimit) !== null && _degradedFieldAnalysi !== void 0 ? _degradedFieldAnalysi : 0
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_message_callout.MessageCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })), /*#__PURE__*/_react.default.createElement(_field_limit_documentation_link.FieldLimitDocLink, null)));
}