"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Warnings;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_dataset_quality_state = require("../../../hooks/use_dataset_quality_state");
var _use_dataset_quality_warnings = require("../../../hooks/use_dataset_quality_warnings");
var _failure_store_warning = require("../../failure_store/failure_store_warning");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nonAggregatableWarningTitle = _i18n.i18n.translate('xpack.datasetQuality.nonAggregatable.title', {
  defaultMessage: 'Your request may take longer to complete'
});
const nonAggregatableWarningDescription = nonAggregatableDatasets => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.nonAggregatable.description",
  defaultMessage: "{description}",
  values: {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.nonAggregatable.warning",
      defaultMessage: "Some of your datasets do not support _ignored aggregation and may cause delays when querying data. {howToFixIt} {showDatasets}",
      values: {
        showDatasets: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.datasetQuality.nonAggregatable.warning.description.",
          defaultMessage: "{accordion}",
          values: {
            accordion: /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
              css: {
                marginTop: '12px '
              },
              buttonContent: _i18n.i18n.translate('xpack.datasetQuality.nonAggregatable.showAffectedDatasets', {
                defaultMessage: 'Show affected datasets'
              }),
              id: ''
            }, /*#__PURE__*/_react.default.createElement("ul", null, nonAggregatableDatasets.map(dataset => /*#__PURE__*/_react.default.createElement("li", {
              key: dataset
            }, dataset))))
          }
        }),
        howToFixIt: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.datasetQuality.nonAggregatable.howToFixIt",
          defaultMessage: "Manually {rolloverLink} these datasets to prevent future delays.",
          values: {
            rolloverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              external: true,
              target: "_blank",
              "data-test-subj": "datasetQualityNonAggregatableHowToFixItLink",
              href: "https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-rollover-index.html"
            }, _i18n.i18n.translate('xpack.datasetQuality.nonAggregatableDatasets.link.title', {
              defaultMessage: 'rollover'
            }))
          }
        })
      }
    })
  }
});

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Warnings() {
  const {
    loading,
    nonAggregatableDatasets
  } = (0, _use_dataset_quality_warnings.useDatasetQualityWarnings)();
  const {
    statsLoading,
    canUserReadFailureStore,
    canUserReadAnyDataset,
    canUserMonitorAnyDataset
  } = (0, _use_dataset_quality_state.useDatasetQualityState)();
  const canAccessAnyDataset = canUserReadAnyDataset || canUserMonitorAnyDataset;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "datasetQualityWarningsContainer",
    gutterSize: "s",
    wrap: true
  }, !loading && nonAggregatableDatasets.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: nonAggregatableWarningTitle,
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, nonAggregatableWarningDescription(nonAggregatableDatasets)))), !statsLoading && !canUserReadFailureStore && canAccessAnyDataset && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_failure_store_warning.FailureStoreWarning, null)));
}
module.exports = exports.default;