"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = exports.EDITOR_MODE = void 0;
var _react = _interopRequireDefault(require("react"));
var _codeEditor = require("@kbn/code-editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITOR_MODE = exports.EDITOR_MODE = {
  TEXT: 'text',
  JSON: 'json'
};
const JsonEditor = ({
  value,
  height = '500px',
  // 99% width allows the editor to resize horizontally. 100% prevents it from resizing.
  width = '99%',
  mode = EDITOR_MODE.JSON,
  readOnly = false,
  onChange = () => {}
}) => {
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: value,
    width: width,
    height: height,
    languageId: mode,
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    options: {
      tabSize: 2,
      readOnly,
      automaticLayout: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      quickSuggestions: true
    },
    onChange: onChange
  });
};
exports.JsonEditor = JsonEditor;