"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mappings = exports.IngestPipeline = exports.IndexSettings = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _json_editor = require("../../json_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITOR_HEIGHT = '300px';
const IndexSettings = ({
  initialized,
  data,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.indexSettingsLabel",
      defaultMessage: "Index settings"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: _json_editor.EDITOR_MODE.JSON,
    readOnly: initialized === true,
    value: data,
    height: EDITOR_HEIGHT,
    onChange: onChange
  }));
};
exports.IndexSettings = IndexSettings;
const Mappings = ({
  initialized,
  data,
  onChange,
  indexName
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: indexName ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.mappingsOfIndexLabel",
      defaultMessage: "Mappings of index {indexName}",
      values: {
        indexName
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.mappingsLabel",
      defaultMessage: "Mappings"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: _json_editor.EDITOR_MODE.JSON,
    readOnly: initialized === true,
    value: data,
    height: EDITOR_HEIGHT,
    onChange: onChange
  }));
};
exports.Mappings = Mappings;
const IngestPipeline = ({
  initialized,
  data,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.ingestPipelineLabel",
      defaultMessage: "Ingest pipeline"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: _json_editor.EDITOR_MODE.JSON,
    readOnly: initialized === true,
    value: data,
    height: EDITOR_HEIGHT,
    onChange: onChange
  }));
};
exports.IngestPipeline = IngestPipeline;