"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProbabilityUsedMessage = void 0;
var _mlIsDefined = require("@kbn/ml-is-defined");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProbabilityUsedMessage = ({
  samplingProbability
}) => {
  return (0, _mlIsDefined.isDefined)(samplingProbability) ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dvRandomSamplerProbabilityUsedMsg"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.randomSamplerSettingsPopUp.probabilityLabel",
    defaultMessage: "Probability used: {samplingProbability}%",
    values: {
      samplingProbability: samplingProbability * 100
    }
  })) : null;
};
exports.ProbabilityUsedMessage = ProbabilityUsedMessage;