"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShadowingFieldWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ShadowingFieldWarning = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('indexPatternFieldEditor.editor.form.fieldShadowingCalloutTitle', {
      defaultMessage: 'Field shadowing'
    }),
    color: "warning",
    iconType: "pin",
    size: "s",
    "data-test-subj": "shadowingFieldCallout"
  }, /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('indexPatternFieldEditor.editor.form.fieldShadowingCalloutDescription', {
    defaultMessage: 'This field shares the name of a mapped field. Values for this field will be returned in search results.'
  })));
};
exports.ShadowingFieldWarning = ShadowingFieldWarning;