"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamSpacesAdapter = void 0;
var _indexAdapter = require("@kbn/index-adapter");
var _create_or_update_data_stream = require("./create_or_update_data_stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamSpacesAdapter extends _indexAdapter.IndexPatternAdapter {
  setIndexTemplate(params) {
    super.setIndexTemplate({
      ...params,
      isDataStream: true
    });
  }
  async _install(params) {
    const {
      logger,
      pluginStop$,
      tasksTimeoutMs
    } = params;
    await this.installTemplates(params);
    const esClient = await params.esClient;
    const installFn = this.getInstallFn({
      logger,
      pluginStop$,
      tasksTimeoutMs
    });

    // Update existing space data streams
    await installFn((0, _create_or_update_data_stream.updateDataStreams)({
      name: `${this.prefix}-*`,
      esClient,
      logger,
      totalFieldsLimit: this.totalFieldsLimit,
      writeIndexOnly: this.writeIndexOnly
    }), `update space data streams`);

    // define function to install data stream on demand
    return async name => installFn((0, _create_or_update_data_stream.createDataStream)({
      name,
      esClient,
      logger
    }), `create ${name} data stream`);
  }

  /**
   * Method to create the data stream for a given space ID.
   * It resolves with the full data stream name.
   */
  async installSpace(spaceId) {
    await this.createIndex(spaceId);
    return this.getIndexName(spaceId);
  }
  async getInstalledSpaceName(spaceId) {
    return this.getInstalledIndexName(spaceId);
  }
}
exports.DataStreamSpacesAdapter = DataStreamSpacesAdapter;