"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APP = void 0;
exports.registerSearchSessionsMgmt = registerSearchSessionsMgmt;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const APP = exports.APP = {
  id: _constants.SEARCH_SESSIONS_MANAGEMENT_ID,
  getI18nName: () => _i18n.i18n.translate('data.mgmt.searchSessions.appTitle', {
    defaultMessage: 'Search Sessions'
  })
};
function registerSearchSessionsMgmt(coreSetup, deps, config, kibanaVersion) {
  deps.management.sections.section.kibana.registerApp({
    id: APP.id,
    title: APP.getI18nName(),
    order: 1.75,
    mount: async params => {
      const {
        SearchSessionsMgmtApp: MgmtApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const mgmtApp = new MgmtApp(coreSetup, deps, config, kibanaVersion, params);
      return mgmtApp.mountManagementSection();
    }
  });
}