"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppFilter = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getAppFilter = tableData => ({
  type: 'field_value_selection',
  name: _i18n.i18n.translate('data.mgmt.searchSessions.search.filterApp', {
    defaultMessage: 'App'
  }),
  field: 'appId',
  multiSelect: 'or',
  options: [...new Set(tableData.map(data => {
    var _data$appId;
    return (_data$appId = data.appId) !== null && _data$appId !== void 0 ? _data$appId : 'unknown';
  }))].sort().map(appId => ({
    value: appId,
    view: (0, _lodash.capitalize)(appId)
  }))
});
exports.getAppFilter = getAppFilter;