"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEmptyScreen = DashboardEmptyScreen;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../../services/kibana_services");
var _get_dashboard_capabilities = require("../../../utils/get_dashboard_capabilities");
var _execute_add_lens_panel_action = require("../../../dashboard_actions/execute_add_lens_panel_action");
var _add_panel_from_library = require("../../add_panel_from_library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DashboardEmptyScreen() {
  const {
    showWriteControls
  } = (0, _react.useMemo)(() => {
    return (0, _get_dashboard_capabilities.getDashboardCapabilities)();
  }, []);
  const isMounted = (0, _useMountedState.default)();
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isDarkTheme = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const viewMode = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.viewMode$);
  const isEditMode = (0, _react.useMemo)(() => {
    return viewMode === 'edit';
  }, [viewMode]);

  // TODO replace these SVGs with versions from EuiIllustration as soon as it becomes available.
  const imageUrl = _kibana_services.coreServices.http.basePath.prepend(`/plugins/dashboard/assets/${isDarkTheme ? 'dashboards_dark' : 'dashboards_light'}.svg`);

  // If the user ends up in edit mode without write privileges, we shouldn't show the edit prompt.
  const showEditPrompt = showWriteControls && isEditMode;
  const emptyPromptTestSubject = (() => {
    if (showEditPrompt) return 'emptyDashboardWidget';
    return showWriteControls ? 'dashboardEmptyReadWrite' : 'dashboardEmptyReadOnly';
  })();
  const title = (() => {
    const titleString = showEditPrompt ? _i18n.i18n.translate('dashboard.emptyScreen.editModeTitle', {
      defaultMessage: 'This dashboard is empty. Let\u2019s fill it up!'
    }) : showWriteControls ? _i18n.i18n.translate('dashboard.emptyScreen.viewModeTitle', {
      defaultMessage: 'Add visualizations to your dashboard'
    }) : _i18n.i18n.translate('dashboard.emptyScreen.noPermissionsTitle', {
      defaultMessage: 'This dashboard is empty.'
    });
    return /*#__PURE__*/_react.default.createElement("h2", null, titleString);
  })();
  const body = (() => {
    const bodyString = showEditPrompt ? _i18n.i18n.translate('dashboard.emptyScreen.editModeSubtitle', {
      defaultMessage: 'Create a visualization of your data, or add one from the library.'
    }) : showWriteControls ? _i18n.i18n.translate('dashboard.emptyScreen.viewModeSubtitle', {
      defaultMessage: 'Enter edit mode, and then start adding your visualizations.'
    }) : _i18n.i18n.translate('dashboard.emptyScreen.noPermissionsSubtitle', {
      defaultMessage: 'You need additional privileges to edit this dashboard.'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("span", null, bodyString));
  })();
  const actions = (() => {
    if (showEditPrompt) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        gutterSize: "l",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        isLoading: isLoading,
        iconType: "lensApp",
        onClick: async () => {
          setIsLoading(true);
          await (0, _execute_add_lens_panel_action.executeAddLensPanelAction)(dashboardApi);
          if (isMounted()) {
            setIsLoading(false);
          }
        }
      }, _i18n.i18n.translate('dashboard.emptyScreen.createVisualization', {
        defaultMessage: 'Create visualization'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        flush: "left",
        iconType: "folderOpen",
        onClick: () => (0, _add_panel_from_library.addFromLibrary)(dashboardApi)
      }, _i18n.i18n.translate('dashboard.emptyScreen.addFromLibrary', {
        defaultMessage: 'Add from library'
      }))));
    }
    if (showWriteControls) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "pencil",
        onClick: () => dashboardApi.setViewMode('edit')
      }, _i18n.i18n.translate('dashboard.emptyScreen.editDashboard', {
        defaultMessage: 'Edit dashboard'
      }));
    }
  })();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dshEmptyPromptParent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    grow: false,
    "data-test-subj": emptyPromptTestSubject,
    className: "dshEmptyPromptPageTemplate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: imageUrl,
      alt: ""
    }),
    title: title,
    body: body,
    actions: actions,
    titleSize: "xs",
    color: "transparent",
    className: "dshEmptyWidgetContainer"
  })));
}