"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataControlButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AddDataControlButton = ({
  closePopover,
  controlGroupApi,
  ...rest
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const onSave = () => {
    dashboardApi.scrollToTop();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, rest, {
    icon: "plusInCircle",
    "data-test-subj": "controls-create-button",
    disabled: !controlGroupApi,
    "aria-label": (0, _dashboard_app_strings.getAddControlButtonTitle)(),
    onClick: () => {
      controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.openAddDataControlFlyout({
        onSave
      });
      closePopover();
    }
  }), (0, _dashboard_app_strings.getAddControlButtonTitle)());
};
exports.AddDataControlButton = AddDataControlButton;