"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePolling = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePolling = () => {
  const pollIntervalRef = (0, _react.useRef)(null);
  const pollTimeoutRef = (0, _react.useRef)(null);
  const [isPolling, setIsPolling] = (0, _react.useState)(false);
  const stopPolling = (0, _react.useCallback)(() => {
    if (pollIntervalRef.current) {
      clearInterval(pollIntervalRef.current);
      pollIntervalRef.current = null;
    }
    if (pollTimeoutRef.current) {
      clearTimeout(pollTimeoutRef.current);
      pollTimeoutRef.current = null;
    }
    setIsPolling(false);
  }, []);
  const startPolling = (0, _react.useCallback)((intervalMs, onPoll, timeoutMs, onTimeout) => {
    pollIntervalRef.current = window.setInterval(() => onPoll(), intervalMs);
    if (timeoutMs) {
      pollTimeoutRef.current = window.setTimeout(() => {
        stopPolling();
        onTimeout === null || onTimeout === void 0 ? void 0 : onTimeout();
      }, timeoutMs);
    }
    setIsPolling(true);
  }, [stopPolling]);
  (0, _react.useEffect)(() => {
    return () => {
      stopPolling();
    };
  }, [stopPolling]);
  return {
    isPolling,
    startPolling,
    stopPolling
  };
};
exports.usePolling = usePolling;