"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternIndicesPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _auto_follow_pattern = require("../services/auto_follow_pattern");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutoFollowPatternIndicesPreview = ({
  prefix,
  suffix,
  leaderIndexPatterns
}) => {
  const {
    indicesPreview
  } = (0, _auto_follow_pattern.getPreviewIndicesFromAutoFollowPattern)({
    prefix,
    suffix,
    leaderIndexPatterns
  });
  const title = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.indicesPreviewTitle', {
    defaultMessage: 'Index name examples'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    iconType: "indexMapping",
    "data-test-subj": "autoFollowPatternIndicesPreview"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.autoFollowPatternForm.indicesPreviewDescription",
    defaultMessage: "The above settings will generate index names that look like this:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, indicesPreview.map(({
    followPattern: {
      prefix,
      suffix,
      template
    }
  }, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i,
    "data-test-subj": "indexPreview"
  }, prefix, /*#__PURE__*/_react.default.createElement("strong", null, template), suffix))));
};
exports.AutoFollowPatternIndicesPreview = AutoFollowPatternIndicesPreview;