"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThemeSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function parseThemeTags() {
  if (!process.env.KBN_OPTIMIZER_THEMES || process.env.KBN_OPTIMIZER_THEMES === '*') {
    return ['v8light', 'v8dark'];
  }
  return process.env.KBN_OPTIMIZER_THEMES.split(',').map(t => t.trim());
}
function getThemeInfo(options) {
  var _options$isDist;
  if ((_options$isDist = options === null || options === void 0 ? void 0 : options.isDist) !== null && _options$isDist !== void 0 ? _options$isDist : true) {
    return {
      defaultDarkMode: false
    };
  }
  const themeTags = parseThemeTags();
  return {
    defaultDarkMode: themeTags[0].endsWith('dark')
  };
}
const getThemeSettings = (options = {}) => {
  const {
    defaultDarkMode
  } = getThemeInfo(options);
  return {
    'theme:darkMode': {
      name: _i18n.i18n.translate('core.ui_settings.params.darkModeTitle', {
        defaultMessage: 'Dark mode'
      }),
      value: defaultDarkMode ? 'enabled' : 'disabled',
      description: _i18n.i18n.translate('core.ui_settings.params.darkModeText', {
        defaultMessage: `The UI theme that the Kibana UI should use. ` + `Set to 'Enabled' to enable the dark theme, or 'Disabled' to disable it. ` + `Set to 'Sync with system' to have the Kibana UI theme follow the system theme. ` + `A page reload is required for the setting to be applied.`
      }),
      type: 'select',
      options: ['enabled', 'disabled', 'system'],
      optionLabels: {
        enabled: _i18n.i18n.translate('core.ui_settings.params.darkMode.options.enabled', {
          defaultMessage: `Enabled`
        }),
        disabled: _i18n.i18n.translate('core.ui_settings.params.darkMode.options.disabled', {
          defaultMessage: `Disabled`
        }),
        system: _i18n.i18n.translate('core.ui_settings.params.darkMode.options.system', {
          defaultMessage: `Sync with system`
        })
      },
      requiresPageReload: true,
      schema: _configSchema.schema.oneOf([_configSchema.schema.literal('enabled'), _configSchema.schema.literal('disabled'), _configSchema.schema.literal('system'),
      // for backward-compatibility
      _configSchema.schema.boolean()])
    },
    /**
     * Theme is sticking around as there are still a number of places reading it and
     * we might use it again in the future.
     */
    'theme:version': {
      name: _i18n.i18n.translate('core.ui_settings.params.themeVersionTitle', {
        defaultMessage: 'Theme version'
      }),
      value: 'v8',
      readonly: true,
      schema: _configSchema.schema.literal('v8')
    }
  };
};
exports.getThemeSettings = getThemeSettings;