"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalConfig$ = exports.getGlobalConfig = void 0;
var _rxjs = require("rxjs");
var _utils = require("@kbn/utils");
var _std = require("@kbn/std");
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _corePluginsServer = require("@kbn/core-plugins-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createGlobalConfig = ({
  elasticsearch,
  path,
  savedObjects
}) => {
  return (0, _std.deepFreeze)({
    elasticsearch: (0, _std.pick)(elasticsearch, _corePluginsServer.SharedGlobalConfigKeys.elasticsearch),
    path: (0, _std.pick)(path, _corePluginsServer.SharedGlobalConfigKeys.path),
    savedObjects: (0, _std.pick)(savedObjects, _corePluginsServer.SharedGlobalConfigKeys.savedObjects)
  });
};
const getGlobalConfig = configService => {
  return createGlobalConfig({
    elasticsearch: configService.atPathSync(_coreElasticsearchServerInternal.config.path),
    path: configService.atPathSync(_utils.config.path),
    savedObjects: configService.atPathSync(_coreSavedObjectsBaseServerInternal.savedObjectsConfig.path)
  });
};
exports.getGlobalConfig = getGlobalConfig;
const getGlobalConfig$ = configService => {
  return (0, _rxjs.combineLatest)([configService.atPath(_coreElasticsearchServerInternal.config.path), configService.atPath(_utils.config.path), configService.atPath(_coreSavedObjectsBaseServerInternal.savedObjectsConfig.path)]).pipe((0, _rxjs.map)(([elasticsearch, path, savedObjects]) => createGlobalConfig({
    elasticsearch,
    path,
    savedObjects
  }), (0, _rxjs.shareReplay)(1)));
};
exports.getGlobalConfig$ = getGlobalConfig$;