"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverlayService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _banners = require("./banners");
var _flyout = require("./flyout");
var _modal = require("./modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class OverlayService {
  constructor() {
    (0, _defineProperty2.default)(this, "bannersService", new _banners.OverlayBannersService());
    (0, _defineProperty2.default)(this, "modalService", new _modal.ModalService());
    (0, _defineProperty2.default)(this, "flyoutService", new _flyout.FlyoutService());
  }
  start({
    targetDomElement,
    ...startDeps
  }) {
    const flyoutElement = document.createElement('div');
    targetDomElement.appendChild(flyoutElement);
    const flyouts = this.flyoutService.start({
      targetDomElement: flyoutElement,
      ...startDeps
    });
    const banners = this.bannersService.start(startDeps);
    const modalElement = document.createElement('div');
    targetDomElement.appendChild(modalElement);
    const modals = this.modalService.start({
      targetDomElement: modalElement,
      ...startDeps
    });
    return {
      banners,
      openFlyout: flyouts.open.bind(flyouts),
      openModal: modals.open.bind(modals),
      openConfirm: modals.openConfirm.bind(modals)
    };
  }
}
exports.OverlayService = OverlayService;