"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnalyticsContextProvider = registerAnalyticsContextProvider;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerAnalyticsContextProvider({
  analytics,
  location$
}) {
  analytics.registerContextProvider({
    name: 'page url',
    context$: location$.pipe((0, _rxjs.map)(location => ({
      page_url: location
    }))),
    schema: {
      page_url: {
        type: 'text',
        _meta: {
          description: 'The page url'
        }
      }
    }
  });
}