"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThemeStylesheetPaths = exports.getSettingValue = exports.getScriptPaths = exports.getCommonStylesheetPaths = exports.getBundlesHref = exports.getBrowserLoggingConfig = void 0;
var _rxjs = require("rxjs");
var UiSharedDepsSrc = _interopRequireWildcard(require("@kbn/ui-shared-deps-src"));
var _coreLoggingServerInternal = require("@kbn/core-logging-server-internal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSettingValue = (settingName, settings, convert) => {
  var _settings$user$settin, _settings$user, _settings$user$settin2;
  const value = (_settings$user$settin = (_settings$user = settings.user) === null || _settings$user === void 0 ? void 0 : (_settings$user$settin2 = _settings$user[settingName]) === null || _settings$user$settin2 === void 0 ? void 0 : _settings$user$settin2.userValue) !== null && _settings$user$settin !== void 0 ? _settings$user$settin : settings.defaults[settingName].value;
  return convert(value);
};
exports.getSettingValue = getSettingValue;
const getBundlesHref = baseHref => `${baseHref}/bundles`;
exports.getBundlesHref = getBundlesHref;
const getScriptPaths = ({
  baseHref,
  darkMode
}) => {
  if (darkMode === 'system') {
    return [`${baseHref}/ui/bootstrap_system_theme_amsterdam.js`];
  } else {
    return [];
  }
};
exports.getScriptPaths = getScriptPaths;
const getCommonStylesheetPaths = ({
  baseHref
}) => {
  const bundlesHref = getBundlesHref(baseHref);
  return [`${bundlesHref}/kbn-ui-shared-deps-src/${UiSharedDepsSrc.cssDistFilename}`, `${baseHref}/ui/legacy_styles.css`];
};
exports.getCommonStylesheetPaths = getCommonStylesheetPaths;
const getThemeStylesheetPaths = ({
  darkMode,
  baseHref
}) => {
  return [...(darkMode ? [`${baseHref}/ui/legacy_dark_theme.min.css`] : [`${baseHref}/ui/legacy_light_theme.min.css`])];
};
exports.getThemeStylesheetPaths = getThemeStylesheetPaths;
const getBrowserLoggingConfig = async configService => {
  const loggingConfig = await (0, _rxjs.firstValueFrom)(configService.atPath(_coreLoggingServerInternal.config.path));
  return loggingConfig.browser;
};
exports.getBrowserLoggingConfig = getBrowserLoggingConfig;