"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchElasticsearchClient = void 0;
var _util = require("util");
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const patchElasticsearchClient = () => {
  const baseErrorPrototype = _elasticsearch.errors.ElasticsearchClientError.prototype;
  // @ts-expect-error
  baseErrorPrototype.toJSON = function () {
    return {
      name: this.name,
      message: this.message
    };
  };

  // @ts-expect-error
  baseErrorPrototype[_util.inspect.custom] = function () {
    // @ts-expect-error
    return this.toJSON();
  };
};
exports.patchElasticsearchClient = patchElasticsearchClient;