"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlGroupStateBuilder = void 0;
var _uuid = require("uuid");
var _common = require("../../../common");
var _kibana_services = require("../../services/kibana_services");
var _data_control_editor_utils = require("../../controls/data_controls/data_control_editor_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlGroupStateBuilder = exports.controlGroupStateBuilder = {
  addDataControlFromField: async (controlGroupState, controlState, controlId) => {
    var _controlGroupState$in;
    controlGroupState.initialChildControlState = {
      ...((_controlGroupState$in = controlGroupState.initialChildControlState) !== null && _controlGroupState$in !== void 0 ? _controlGroupState$in : {}),
      [controlId !== null && controlId !== void 0 ? controlId : (0, _uuid.v4)()]: {
        type: await getCompatibleControlType(controlState.dataViewId, controlState.fieldName),
        order: getNextControlOrder(controlGroupState.initialChildControlState),
        ...controlState
      }
    };
  },
  addOptionsListControl: (controlGroupState, controlState, controlId) => {
    var _controlGroupState$in2;
    controlGroupState.initialChildControlState = {
      ...((_controlGroupState$in2 = controlGroupState.initialChildControlState) !== null && _controlGroupState$in2 !== void 0 ? _controlGroupState$in2 : {}),
      [controlId !== null && controlId !== void 0 ? controlId : (0, _uuid.v4)()]: {
        type: _common.OPTIONS_LIST_CONTROL,
        order: getNextControlOrder(controlGroupState.initialChildControlState),
        ...controlState
      }
    };
  },
  addRangeSliderControl: (controlGroupState, controlState, controlId) => {
    var _controlGroupState$in3;
    controlGroupState.initialChildControlState = {
      ...((_controlGroupState$in3 = controlGroupState.initialChildControlState) !== null && _controlGroupState$in3 !== void 0 ? _controlGroupState$in3 : {}),
      [controlId !== null && controlId !== void 0 ? controlId : (0, _uuid.v4)()]: {
        type: _common.RANGE_SLIDER_CONTROL,
        order: getNextControlOrder(controlGroupState.initialChildControlState),
        ...controlState
      }
    };
  },
  addTimeSliderControl: (controlGroupState, controlId) => {
    var _controlGroupState$in4;
    controlGroupState.initialChildControlState = {
      ...((_controlGroupState$in4 = controlGroupState.initialChildControlState) !== null && _controlGroupState$in4 !== void 0 ? _controlGroupState$in4 : {}),
      [controlId !== null && controlId !== void 0 ? controlId : (0, _uuid.v4)()]: {
        type: _common.TIME_SLIDER_CONTROL,
        order: getNextControlOrder(controlGroupState.initialChildControlState),
        width: 'large'
      }
    };
  }
};
async function getCompatibleControlType(dataViewId, fieldName) {
  const dataView = await _kibana_services.dataViewsService.get(dataViewId);
  const fieldRegistry = await (0, _data_control_editor_utils.getDataControlFieldRegistry)(dataView);
  const field = fieldRegistry[fieldName];
  if (field.compatibleControlTypes.length === 0) {
    throw new Error(`No compatible control type found for field: ${fieldName}`);
  }
  return field.compatibleControlTypes[0];
}
function getNextControlOrder(controlPanelsState) {
  if (!controlPanelsState) {
    return 0;
  }
  const values = Object.values(controlPanelsState);
  if (values.length === 0) {
    return 0;
  }
  let highestOrder = 0;
  values.forEach(controlPanelState => {
    if (controlPanelState.order > highestOrder) {
      highestOrder = controlPanelState.order;
    }
  });
  return highestOrder + 1;
}