"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFavorites = registerFavorites;
var _favorites_routes = require("./favorites_routes");
var _favorites_saved_object = require("./favorites_saved_object");
var _favorites_usage_collection = require("./favorites_usage_collection");
var _favorites_registry = require("./favorites_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @public
 * Setup contract for the favorites feature.
 */

/**
 * @public
 * Registers the favorites feature enabling favorites saved object type and api routes.
 *
 * @param logger
 * @param core
 * @param usageCollection
 */
function registerFavorites({
  logger,
  core,
  usageCollection
}) {
  const favoritesRegistry = new _favorites_registry.FavoritesRegistry();
  core.savedObjects.registerType(_favorites_saved_object.favoritesSavedObjectType);
  (0, _favorites_routes.registerFavoritesRoutes)({
    core,
    logger,
    favoritesRegistry
  });
  if (usageCollection) {
    (0, _favorites_usage_collection.registerFavoritesUsageCollection)({
      core,
      usageCollection
    });
  }
  return favoritesRegistry;
}