"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.History = void 0;
exports.createHistory = createHistory;
exports.isQuotaExceededError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_NUMBER_OF_HISTORY_ITEMS = 100;
const isQuotaExceededError = e => e.name === 'QuotaExceededError';
exports.isQuotaExceededError = isQuotaExceededError;
class History {
  constructor(storage) {
    (0, _defineProperty2.default)(this, "changeEmitter", void 0);
    this.storage = storage;
    this.changeEmitter = new _rxjs.BehaviorSubject(this.getHistory() || []);
  }
  getHistoryKeys() {
    return this.storage.keys().filter(key => key.indexOf('hist_elem') === 0).sort().reverse();
  }
  getHistory() {
    return this.getHistoryKeys().map(key => this.storage.get(key));
  }

  // This is used as an optimization mechanism so that different components
  // can listen for changes to history and update because changes to history can
  // be triggered from different places in the app. The alternative would be to store
  // this in state so that we hook into the React model, but it would require loading history
  // every time the application starts even if a user is not going to view history.
  change(listener) {
    const subscription = this.changeEmitter.subscribe(listener);
    return () => subscription.unsubscribe();
  }
  addToHistory(endpoint, method, data) {
    const keys = this.getHistoryKeys();
    keys.splice(0, MAX_NUMBER_OF_HISTORY_ITEMS); // only maintain most recent X;
    keys.forEach(key => {
      this.storage.delete(key);
    });
    const timestamp = new Date().getTime();
    const k = 'hist_elem_' + timestamp;
    this.storage.set(k, {
      time: timestamp,
      endpoint,
      method,
      data
    });
    this.changeEmitter.next(this.getHistory());
  }
  updateCurrentState(content) {
    const timestamp = new Date().getTime();
    this.storage.set('editor_state', {
      time: timestamp,
      content
    });
  }
  getLegacySavedEditorState() {
    const saved = this.storage.get('editor_state');
    if (!saved) return;
    const {
      time,
      content
    } = saved;
    return {
      time,
      content
    };
  }

  /**
   * This function should only ever be called once for a user if they had legacy state.
   */
  deleteLegacySavedEditorState() {
    this.storage.delete('editor_state');
  }
  clearHistory() {
    this.getHistoryKeys().forEach(key => this.storage.delete(key));
  }
}
exports.History = History;
function createHistory(deps) {
  return new History(deps.storage);
}