"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.safeExpandLiteralStrings = exports.languageForContentType = exports.isMapboxVectorTile = exports.isJSONContentType = void 0;
var _monaco = require("@kbn/monaco");
var _shared_imports = require("../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isJSONContentType = contentType => Boolean(contentType && contentType.indexOf('application/json') >= 0);
exports.isJSONContentType = isJSONContentType;
const isMapboxVectorTile = contentType => {
  var _contentType$includes;
  return (_contentType$includes = contentType === null || contentType === void 0 ? void 0 : contentType.includes('application/vnd.mapbox-vector-tile')) !== null && _contentType$includes !== void 0 ? _contentType$includes : false;
};

/**
 * Best effort expand literal strings
 */
exports.isMapboxVectorTile = isMapboxVectorTile;
const safeExpandLiteralStrings = data => {
  try {
    return (0, _shared_imports.expandLiteralStrings)(data);
  } catch (e) {
    return data;
  }
};
exports.safeExpandLiteralStrings = safeExpandLiteralStrings;
const TEXT_LANGUAGE_ID = 'text';
const languageForContentType = contentType => {
  if (!contentType) {
    return TEXT_LANGUAGE_ID;
  }
  if (isJSONContentType(contentType) || isMapboxVectorTile(contentType)) {
    // Using hjson will allow us to use comments in editor output and solves the problem with error markers
    return _monaco.CONSOLE_OUTPUT_LANG_ID;
  } else if (contentType.indexOf('application/yaml') >= 0) {
    return _monaco.YAML_LANG_ID;
  }
  return TEXT_LANGUAGE_ID;
};
exports.languageForContentType = languageForContentType;