"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBenchmarksData = exports.getBenchmarks = void 0;
var _constants = require("../../../common/constants");
var _helpers = require("../../../common/utils/helpers");
var _fleet_util = require("../../lib/fleet_util");
var _utilities = require("./utilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBenchmarksData = (soClient, agentPolicies, agentStatusByAgentPolicyId, cspPackagePolicies) => {
  const cspPackagePoliciesMap = new Map(cspPackagePolicies.map(packagePolicy => [packagePolicy.id, packagePolicy]));
  return Promise.all(agentPolicies.flatMap(agentPolicy => {
    var _agentPolicy$package_, _agentPolicy$package_2;
    const cspPackagesOnAgent = (_agentPolicy$package_ = (_agentPolicy$package_2 = agentPolicy.package_policies) === null || _agentPolicy$package_2 === void 0 ? void 0 : _agentPolicy$package_2.map(({
      id: pckPolicyId
    }) => {
      return cspPackagePoliciesMap.get(pckPolicyId);
    }).filter(_helpers.isNonNullable)) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : [];
    const benchmarks = cspPackagesOnAgent.map(async cspPackage => {
      var _agentStatusByAgentPo;
      const benchmarkId = (0, _helpers.getBenchmarkFromPackagePolicy)(cspPackage.inputs);
      const rulesCount = await (0, _utilities.getRulesCountForPolicy)(soClient, benchmarkId);
      const agentPolicyStatus = {
        id: agentPolicy.id,
        name: agentPolicy.name,
        agents: (_agentStatusByAgentPo = agentStatusByAgentPolicyId[agentPolicy.id]) === null || _agentStatusByAgentPo === void 0 ? void 0 : _agentStatusByAgentPo.total
      };
      return {
        package_policy: cspPackage,
        agent_policy: agentPolicyStatus,
        rules_count: rulesCount
      };
    });
    return benchmarks;
  }));
};
exports.getBenchmarksData = getBenchmarksData;
const getBenchmarks = async (soClient, packagePolicyService, query, agentPolicyService, agentService, logger) => {
  const excludeVulnMgmtPackages = true;
  const packagePolicies = await (0, _fleet_util.getCspPackagePolicies)(soClient, packagePolicyService, _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME, query, _constants.POSTURE_TYPE_ALL, excludeVulnMgmtPackages);
  const agentPolicies = await (0, _fleet_util.getCspAgentPolicies)(soClient, packagePolicies.items, agentPolicyService);
  const agentStatusesByAgentPolicyId = await (0, _fleet_util.getAgentStatusesByAgentPolicies)(agentService, agentPolicies, logger);
  const benchmarks = await getBenchmarksData(soClient, agentPolicies, agentStatusesByAgentPolicyId, packagePolicies.items);
  const getBenchmarkResponse = {
    ...packagePolicies,
    items: benchmarks
  };
  return getBenchmarkResponse;
};
exports.getBenchmarks = getBenchmarks;