"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoVulnerabilitiesStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _reactRouterDom = require("react-router-dom");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _empty_states_illustration_container = require("./empty_states_illustration_container");
var _constants = require("../../common/constants");
var _full_size_centered_page = require("./full_size_centered_page");
var _cloud_posture_page = require("./cloud_posture_page");
var _test_subjects = require("./test_subjects");
var _use_csp_integration_link = require("../common/navigation/use_csp_integration_link");
var _use_navigate_to_cis_integration_policies = require("../common/navigation/use_navigate_to_cis_integration_policies");
var _use_wiz_integration_route = require("../common/api/use_wiz_integration_route");
var _clouds = _interopRequireDefault(require("../assets/illustrations/clouds.svg"));
var _constants2 = require("../common/navigation/constants");
var _vulnerabilities_vendors = _interopRequireDefault(require("../assets/illustrations/vulnerabilities_vendors.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFETCH_INTERVAL_MS = 20000;
const ScanningVulnerabilitiesEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.SCANNING_VULNERABILITIES,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.scanningVulnerabilitiesEmptyPrompt.indexingButtonTitle",
    defaultMessage: "Scanning your environment"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.scanningVulnerabilitiesEmptyPrompt.indexingDescription",
    defaultMessage: "Results will appear here as soon as they are available."
  }))
});
const CnvmIntegrationNotInstalledEmptyPrompt = ({
  vulnMgmtIntegrationLink
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const wizAddIntegrationLink = (0, _use_wiz_integration_route.useAdd3PIntegrationRoute)('wiz');
  const is3PSupportedPage = location.pathname.includes(_cloudSecurityPosture.findingsNavigation.vulnerabilities.path);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    style: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.NOT_INSTALLED,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _clouds.default,
      alt: "clouds",
      role: "presentation"
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.promptTitle",
      defaultMessage: "Elastic\u2019s Cloud Native {lineBreak} Vulnerability Management",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.promptDescription",
      defaultMessage: " Detect and remediate potential vulnerabilities {lineBreak} in your cloud assets, with our Cloud Native {lineBreak} Vulnerability Management(CNVM) integration. {lineBreak} {learnMore}",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null),
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.cnvm.overviewPath,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.learnMoreButtonTitle",
          defaultMessage: "Learn more"
        }))
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: vulnMgmtIntegrationLink,
      isDisabled: !vulnMgmtIntegrationLink,
      "data-test-subj": _test_subjects.CNVM_NOT_INSTALLED_ACTION_SUBJ
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.addVulMngtIntegrationButtonTitle",
      defaultMessage: "Add CNVM Integration"
    }))))
  })), is3PSupportedPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    style: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _test_subjects.THIRD_PARTY_INTEGRATIONS_NO_VULNERABILITIES_FINDINGS_PROMPT,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _vulnerabilities_vendors.default,
      alt: "vulnerabilitiesVendorsSVG",
      role: "presentation"
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoVulnFindingsPrompt.promptTitle",
      defaultMessage: "Already using a {lineBreak} cloud security product?",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoVulnFindingsPrompt.promptDescription",
      defaultMessage: "Ingest data from your existing vulnerability {lineBreak} solution for centralized analytics, hunting, {lineBreak} investigations, visualizations, and more. {lineBreak} Other integrations coming soon.",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: wizAddIntegrationLink,
      isDisabled: !wizAddIntegrationLink,
      "data-test-subj": _test_subjects.THIRD_PARTY_NO_VULNERABILITIES_FINDINGS_PROMPT_WIZ_INTEGRATION_BUTTON
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoVulnFindingsPrompt.addWizIntegrationButtonTitle",
      defaultMessage: "Add Wiz Integration"
    }))))
  })));
};
const CnvmIndexTimeout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.INDEX_TIMEOUT,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutTitle",
    defaultMessage: "Findings Delayed"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutDescription",
    defaultMessage: "Scanning workloads is taking longer than expected. Please check {docs}",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/cnvm-faq",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutDocLink",
        defaultMessage: "CNVM FAQ"
      }))
    }
  }))
});
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.UNPRIVILEGED,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view cloud posture data, you must update privileges. For more information, contact your Kibana administrator."
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``)
  })
});
const AgentNotDeployedEmptyPrompt = ({
  postureType
}) => {
  const integrationPoliciesLink = (0, _use_navigate_to_cis_integration_policies.useCISIntegrationPoliciesLink)({
    postureType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.NOT_DEPLOYED,
    color: "plain",
    iconType: "fleetApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedTitle",
      defaultMessage: "No Agents Installed"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedDescription",
      defaultMessage: "In order to begin detecting vulnerabilities, you'll need to deploy elastic-agent into the cloud account or Kubernetes cluster you want to monitor."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: integrationPoliciesLink,
      isDisabled: !integrationPoliciesLink
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedButtonTitle",
      defaultMessage: "Install Agent"
    }))]
  });
};

/**
 * This component will return the render states based on cloud posture setup status API
 * since 'not-installed' is being checked globally by CloudPosturePage and 'indexed' is the pass condition, those states won't be handled here
 * */
const NoVulnerabilitiesStates = () => {
  var _getSetupStatus$data, _getSetupStatus$data$, _getSetupStatus$data2;
  const getSetupStatus = (0, _use_csp_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: REFETCH_INTERVAL_MS
  });
  const vulnMgmtIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.VULN_MGMT_POLICY_TEMPLATE);
  const status = (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.vuln_mgmt) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status;
  const indicesStatus = (_getSetupStatus$data2 = getSetupStatus.data) === null || _getSetupStatus$data2 === void 0 ? void 0 : _getSetupStatus$data2.indicesDetails;
  const unprivilegedIndices = indicesStatus && indicesStatus.filter(idxDetails => idxDetails.status === 'unprivileged').map(idxDetails => idxDetails.index).sort((a, b) => a.localeCompare(b));
  const render = () => {
    if (status === 'indexing' || status === 'waiting_for_results') return /*#__PURE__*/_react.default.createElement(ScanningVulnerabilitiesEmptyPrompt, null); // integration installed, but no agents added// agent added, index timeout has passed
    if (status === 'index-timeout') return /*#__PURE__*/_react.default.createElement(CnvmIndexTimeout, null);
    if (status === 'not-installed') return /*#__PURE__*/_react.default.createElement(CnvmIntegrationNotInstalledEmptyPrompt, {
      vulnMgmtIntegrationLink: vulnMgmtIntegrationLink
    });
    if (status === 'not-deployed') return /*#__PURE__*/_react.default.createElement(AgentNotDeployedEmptyPrompt, {
      postureType: _constants.VULN_MGMT_POLICY_TEMPLATE
    });
    if (status === 'unprivileged') return /*#__PURE__*/_react.default.createElement(Unprivileged, {
      unprivilegedIndices: unprivilegedIndices || []
    }); // user has no privileges for our indices
  };
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getSetupStatus
  }, /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, null, render()));
};
exports.NoVulnerabilitiesStates = NoVulnerabilitiesStates;