"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setElasticsearchRoute = setElasticsearchRoute;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setElasticsearchRoute({
  elasticsearchUrl,
  logger,
  router
}) {
  router.versioned.get({
    path: _constants.ELASTICSEARCH_CONFIG_ROUTE,
    access: 'internal'
  }).addVersion({
    version: '1',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {}
  }, async (context, request, response) => {
    const body = {
      elasticsearch_url: elasticsearchUrl
    };
    return response.ok({
      body
    });
  });
}