"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseUserActionBuilder = void 0;
var _domain = require("../../../../common/types/domain");
var _constants = require("../../../../common/constants");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CreateCaseUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    const {
      payload,
      caseId,
      owner,
      user
    } = args;
    const action = _domain.UserActionActions.create;
    const connectorWithoutId = this.extractConnectorId(payload.connector);
    const parameters = {
      attributes: {
        ...this.getCommonUserActionAttributes({
          user,
          owner
        }),
        action,
        payload: {
          ...payload,
          connector: connectorWithoutId,
          status: _domain.CaseStatuses.open
        },
        type: _domain.UserActionTypes.create_case
      },
      references: [...this.createCaseReferences(caseId), ...this.createConnectorReference(payload.connector.id)]
    };
    const getMessage = id => `User created case id: ${caseId} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: 'case_user_action_create_case',
      savedObjectId: caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.CreateCaseUserActionBuilder = CreateCaseUserActionBuilder;