"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryExpandedAlertsSchema = exports.AttackDiscoveryExpandedAlertSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AttackDiscoveryExpandedAlertSchema = exports.AttackDiscoveryExpandedAlertSchema = _configSchema.schema.object({
  _id: _configSchema.schema.string(),
  _index: _configSchema.schema.string(),
  kibana: _configSchema.schema.object({
    alert: _configSchema.schema.object({
      attack_discovery: _configSchema.schema.object({
        alert_ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
        details_markdown: _configSchema.schema.string(),
        entity_summary_markdown: _configSchema.schema.maybe(_configSchema.schema.string()),
        mitre_attack_tactics: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
        replacements: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
          value: _configSchema.schema.string(),
          uuid: _configSchema.schema.string()
        }))),
        summary_markdown: _configSchema.schema.string(),
        title: _configSchema.schema.string()
      }),
      rule: _configSchema.schema.object({
        parameters: _configSchema.schema.object({
          alertsIndexPattern: _configSchema.schema.string()
        }),
        rule_type_id: _configSchema.schema.string()
      })
    })
  })
});
const AttackDiscoveryExpandedAlertsSchema = exports.AttackDiscoveryExpandedAlertsSchema = _configSchema.schema.arrayOf(AttackDiscoveryExpandedAlertSchema);