"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPartialCaseTransformedAttributesRt = exports.OwnerRt = exports.CaseTransformedAttributesRt = exports.CasePersistedStatus = exports.CasePersistedSeverity = void 0;
var _ioTs = require("io-ts");
var _domain = require("../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CasePersistedSeverity = exports.CasePersistedSeverity = /*#__PURE__*/function (CasePersistedSeverity) {
  CasePersistedSeverity[CasePersistedSeverity["LOW"] = 0] = "LOW";
  CasePersistedSeverity[CasePersistedSeverity["MEDIUM"] = 10] = "MEDIUM";
  CasePersistedSeverity[CasePersistedSeverity["HIGH"] = 20] = "HIGH";
  CasePersistedSeverity[CasePersistedSeverity["CRITICAL"] = 30] = "CRITICAL";
  return CasePersistedSeverity;
}({});
let CasePersistedStatus = exports.CasePersistedStatus = /*#__PURE__*/function (CasePersistedStatus) {
  CasePersistedStatus[CasePersistedStatus["OPEN"] = 0] = "OPEN";
  CasePersistedStatus[CasePersistedStatus["IN_PROGRESS"] = 10] = "IN_PROGRESS";
  CasePersistedStatus[CasePersistedStatus["CLOSED"] = 20] = "CLOSED";
  return CasePersistedStatus;
}({});
const CaseTransformedAttributesRt = exports.CaseTransformedAttributesRt = _domain.CaseAttributesRt;
const getPartialCaseTransformedAttributesRt = () => {
  const caseTransformedAttributesProps = _domain.CaseAttributesRt.types.reduce((acc, type) => Object.assign(acc, type.type.props), {});
  return (0, _ioTs.exact)(
  /**
   * We add the `total_comments` and `total_alerts` properties to allow the
   * attachments stats to be updated.
   */
  (0, _ioTs.partial)({
    ...caseTransformedAttributesProps,
    total_comments: _ioTs.number,
    total_alerts: _ioTs.number
  }));
};
exports.getPartialCaseTransformedAttributesRt = getPartialCaseTransformedAttributesRt;
const OwnerRt = exports.OwnerRt = (0, _ioTs.strict)({
  owner: _ioTs.string
});