"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ATTACHMENT_NOT_REGISTERED_ERROR: true,
  DEFAULT_EVENT_ATTACHMENT_TITLE: true,
  MULTIPLE_ALERTS: true,
  ATTACHMENT: true,
  UNSAVED_DRAFT_COMMENT: true,
  DELETE_ALERTS_SUCCESS_TITLE: true,
  DELETE_COMMENT_SUCCESS_TITLE: true,
  DELETE_REGISTERED_ATTACHMENT: true
};
exports.UNSAVED_DRAFT_COMMENT = exports.MULTIPLE_ALERTS = exports.DELETE_REGISTERED_ATTACHMENT = exports.DELETE_COMMENT_SUCCESS_TITLE = exports.DELETE_ALERTS_SUCCESS_TITLE = exports.DEFAULT_EVENT_ATTACHMENT_TITLE = exports.ATTACHMENT_NOT_REGISTERED_ERROR = exports.ATTACHMENT = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACHMENT_NOT_REGISTERED_ERROR = exports.ATTACHMENT_NOT_REGISTERED_ERROR = _i18n.i18n.translate('xpack.cases.userActions.attachmentNotRegisteredErrorMsg', {
  defaultMessage: 'Attachment type is not registered'
});
const DEFAULT_EVENT_ATTACHMENT_TITLE = exports.DEFAULT_EVENT_ATTACHMENT_TITLE = _i18n.i18n.translate('xpack.cases.userActions.defaultEventAttachmentTitle', {
  defaultMessage: 'added an attachment of type'
});
const MULTIPLE_ALERTS = totalAlerts => _i18n.i18n.translate('xpack.cases.caseView.alerts.multipleAlerts', {
  values: {
    totalAlerts
  },
  defaultMessage: '{totalAlerts, plural, =1 {one} other {{totalAlerts}}} {totalAlerts, plural, =1 {alert} other {alerts}}'
});
exports.MULTIPLE_ALERTS = MULTIPLE_ALERTS;
const ATTACHMENT = exports.ATTACHMENT = _i18n.i18n.translate('xpack.cases.userActions.attachment', {
  defaultMessage: 'Attachment'
});
const UNSAVED_DRAFT_COMMENT = exports.UNSAVED_DRAFT_COMMENT = _i18n.i18n.translate('xpack.cases.userActions.comment.unsavedDraftComment', {
  defaultMessage: 'You have unsaved edits for this comment'
});
const DELETE_ALERTS_SUCCESS_TITLE = totalAlerts => _i18n.i18n.translate('xpack.cases.userActions.attachments.alerts.successToasterTitle', {
  defaultMessage: 'Deleted {totalAlerts, plural, =1 {one} other {{totalAlerts}}} {totalAlerts, plural, =1 {alert} other {alerts}}',
  values: {
    totalAlerts
  }
});
exports.DELETE_ALERTS_SUCCESS_TITLE = DELETE_ALERTS_SUCCESS_TITLE;
const DELETE_COMMENT_SUCCESS_TITLE = exports.DELETE_COMMENT_SUCCESS_TITLE = _i18n.i18n.translate('xpack.cases.userActions.attachments.comment.successToasterTitle', {
  defaultMessage: 'Deleted comment'
});
const DELETE_REGISTERED_ATTACHMENT = exports.DELETE_REGISTERED_ATTACHMENT = _i18n.i18n.translate('xpack.cases.userActions.attachments.registeredAttachment.successToasterTitle', {
  defaultMessage: 'Deleted attachment'
});